/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.documents;

import jakarta.inject.Inject;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.core.SnapshotService;
import org.imixs.archive.documents.TikaService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.SignalAdapter;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AdapterException;
import org.imixs.workflow.exceptions.PluginException;

public class OCRDocumentAdapter
implements SignalAdapter {
    public static final String OCR_ERROR = "OCR_ERROR";
    private static Logger logger = Logger.getLogger(OCRDocumentAdapter.class.getName());
    @Inject
    @ConfigProperty(name="ocr.service.mode", defaultValue="auto")
    String serviceMode;
    @Inject
    TikaService ocrService;
    @Inject
    WorkflowService workflowService;
    @Inject
    SnapshotService snapshotService;

    public ItemCollection execute(ItemCollection document, ItemCollection event) throws AdapterException {
        logger.info("......starting TikaDocumentAdapter mode=" + this.serviceMode);
        if ("model".equalsIgnoreCase(this.serviceMode)) {
            logger.finest("...running api adapter...");
            try {
                List tikaOptions = null;
                String filePattern = null;
                int maxPdfPages = 0;
                ItemCollection evalItemCollection = this.workflowService.evalWorkflowResult(event, "tika", document, false);
                if (evalItemCollection != null) {
                    tikaOptions = evalItemCollection.getItemValue("options");
                    filePattern = evalItemCollection.getItemValueString("filepattern");
                    maxPdfPages = evalItemCollection.getItemValueInteger("maxpdfpages");
                }
                this.ocrService.extractText(document, this.snapshotService.findSnapshot(document), null, tikaOptions, filePattern, maxPdfPages);
            }
            catch (PluginException e) {
                String message = "Tika OCRService - unable to extract text: " + e.getMessage();
                throw new AdapterException(e.getErrorContext(), e.getErrorCode(), message, (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                String message = "Tika OCRService - unable to extract text: " + e.getMessage();
                throw new AdapterException(OCRDocumentAdapter.class.getSimpleName(), OCR_ERROR, message, (Exception)e);
            }
        } else {
            logger.warning("unexpected TIKA_SERVICE_MODE=" + this.serviceMode + " - running the OCRDocumentAdapter the env TIKA_SERVICE_MODE should be set to 'model'. Adapter will be ignored!");
        }
        return document;
    }
}

