/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.export.services;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.imixs.archive.export.ExportException;
import org.imixs.archive.export.services.ExportStatusHandler;
import org.imixs.archive.export.services.FileService;
import org.imixs.archive.export.services.LogService;
import org.imixs.archive.export.util.RestClientHelper;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.InvalidAccessException;

@Singleton
@Startup
public class SchedulerService {
    private static Logger logger = Logger.getLogger(SchedulerService.class.getName());
    public static String SNAPSHOTID = "$snapshotid";
    @Inject
    @ConfigProperty(name="workflow.sync.interval", defaultValue="10000")
    long interval;
    @Inject
    @ConfigProperty(name="workflow.sync.initialdelay", defaultValue="30000")
    long initialDelay;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> workflowServiceAuthMethod;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> workflowServiceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> workflowServicePassword;
    @Inject
    @ConfigProperty(name="export.ftp.host")
    Optional<String> ftpServer;
    @Inject
    @ConfigProperty(name="export.path")
    Optional<String> filePath;
    @Inject
    @ConfigProperty(name="eventlog.topic", defaultValue="file.export")
    String topic;
    @Inject
    @ConfigProperty(name="eventlog.deadlock", defaultValue="60000")
    long deadLockInterval;
    @Resource
    TimerService timerService;
    @Inject
    FileService fileService;
    @Inject
    RestClientHelper restClientHelper;
    @Inject
    ExportStatusHandler exportStatusHandler;
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;
    @Inject
    LogService logService;

    @PostConstruct
    public void init() {
        this.logService.info("Setup...");
        if (this.verifyConfiguration()) {
            try {
                this.startScheduler(true);
            }
            catch (ExportException e) {
                this.logService.warning("Failed to init scheduler: " + e.getMessage());
            }
        }
    }

    private boolean verifyConfiguration() {
        if (!this.workflowServiceEndpoint.isPresent()) {
            this.logService.severe("Missing environment param 'WORKFLOW_SERVICE_ENDPOINT' - please verify configuration!");
            return false;
        }
        if (!this.ftpServer.isPresent() && !this.filePath.isPresent()) {
            this.logService.severe("Missing environment param 'EXPORT_FTP_HOST or EXPORT_PATH' - please verify configuration!");
            return false;
        }
        return true;
    }

    @Counted(name="executions", description="Counting the invocations of export service", displayName="executions")
    @Timeout
    public void onTimeout(Timer _timer) {
        String id = null;
        String ref = null;
        int total = 0;
        int success = 0;
        int errors = 0;
        this.exportStatusHandler.setTimer(_timer);
        try {
            DocumentClient documentClient = this.restClientHelper.getDocumentClient();
            EventLogClient eventLogClient = this.restClientHelper.getEventLogClient(documentClient);
            if (documentClient == null || eventLogClient == null) {
                this.logService.warning("Unable to connect to workflow instance endpoint - please verify configuration!");
                try {
                    this.stopScheduler();
                }
                catch (ExportException exportException) {
                    // empty catch block
                }
                this.metricRegistry.counter("errors").inc();
                return;
            }
            this.exportStatusHandler.setStatus("RUNNING");
            logger.finest("......release dead locks....");
            this.releaseDeadLocks(eventLogClient);
            eventLogClient.setPageSize(100);
            List events = eventLogClient.searchEventLog(new String[]{this.topic});
            for (ItemCollection eventLogEntry : events) {
                ++total;
                id = eventLogEntry.getItemValueString("id");
                ref = eventLogEntry.getItemValueString("ref");
                String path = "";
                String filter = "";
                Pattern pattern = null;
                List dataList = eventLogEntry.getItemValue("data");
                if (dataList != null && dataList.size() > 0) {
                    ItemCollection dataItemCol = new ItemCollection((Map)dataList.get(0));
                    path = dataItemCol.getItemValueString("path");
                    filter = dataItemCol.getItemValueString("filter");
                    if (!filter.isEmpty()) {
                        pattern = Pattern.compile(filter);
                    }
                }
                try {
                    eventLogClient.lockEventLogEntry(id);
                    List fileDataList = this.pullFileDataList(eventLogEntry, documentClient, eventLogClient);
                    for (FileData fileData : fileDataList) {
                        Matcher matcher;
                        if (pattern != null && !(matcher = pattern.matcher(fileData.getName())).find()) continue;
                        this.fileService.writeFileData(fileData, path);
                        ++success;
                    }
                    eventLogClient.deleteEventLogEntry(id);
                    this.metricRegistry.counter("org_imixs_archive_export_services_SchedulerService_events").inc();
                }
                catch (EJBException | ExportException | RestAPIException | InvalidAccessException e) {
                    this.logService.warning("ExportEvent " + id + " failed: " + e.getMessage());
                    this.metricRegistry.counter("org_imixs_archive_export_SchedulerService_errors").inc();
                    ++errors;
                    eventLogClient.unlockEventLogEntry(id);
                }
            }
            if (total > 0) {
                this.logService.info(success + " files exported, " + errors + " errors.");
            }
            this.exportStatusHandler.setStatus("SCHEDULED");
        }
        catch (EJBException | RestAPIException | InvalidAccessException e) {
            this.logService.severe("processing EventLog failed: " + e.getMessage());
            this.metricRegistry.counter("org_imixs_archive_export_SchedulerService_errors").inc();
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void releaseDeadLocks(EventLogClient eventLogClient) throws RestAPIException {
        if (eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return;
        }
        eventLogClient.releaseDeadLocks(this.deadLockInterval, new String[]{this.topic});
    }

    public List<FileData> pullFileDataList(ItemCollection eventLogEntry, DocumentClient documentClient, EventLogClient eventLogClient) throws ExportException {
        if (eventLogEntry == null || documentClient == null || eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return null;
        }
        String ref = eventLogEntry.getItemValueString("ref");
        try {
            String id = eventLogEntry.getItemValueString("id");
            logger.finest("......fileData ref=" + ref + "...");
            ItemCollection workitem = documentClient.getDocument(ref);
            if (workitem.getItemValueString(SNAPSHOTID).isEmpty()) {
                return workitem.getFileData();
            }
            ItemCollection snapshot = documentClient.getDocument(workitem.getItemValueString(SNAPSHOTID));
            if (snapshot != null) {
                return snapshot.getFileData();
            }
        }
        catch (RestAPIException e) {
            throw new ExportException("TIMER_EXCEPTION", "Snapshot " + ref + " pull failed", (Exception)((Object)e));
        }
        return null;
    }

    public void restartScheduler() throws ExportException {
        this.stopScheduler();
        this.startScheduler(false);
    }

    public void startScheduler(boolean clearLog) throws ExportException {
        try {
            if (clearLog) {
                // empty if block
            }
            this.logService.info("Starting export scheduler - initalDelay=" + this.initialDelay + "ms  inverval=" + this.interval + "ms ....");
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)""));
            timerConfig.setPersistent(false);
            Timer timer = this.timerService.createIntervalTimer(this.initialDelay, this.interval, timerConfig);
            this.exportStatusHandler.setTimer(timer);
        }
        catch (EJBException | IllegalArgumentException | IllegalStateException e) {
            throw new ExportException("TIMER_EXCEPTION", "Failed to init scheduler ", (Exception)e);
        }
        this.exportStatusHandler.setStatus("SCHEDULED");
    }

    public boolean stopScheduler() throws ExportException {
        Timer timer = this.exportStatusHandler.getTimer();
        if (timer != null) {
            try {
                this.logService.info("Stopping the export scheduler...");
                timer.cancel();
            }
            catch (EJBException | IllegalArgumentException | IllegalStateException e) {
                throw new ExportException("TIMER_EXCEPTION", "Failed to stop scheduler ", (Exception)e);
            }
            this.logService.info("Timer stopped. ");
        }
        this.exportStatusHandler.setStatus("STOPPED");
        return true;
    }
}

