/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.export.services;

import jakarta.ejb.Singleton;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

@Singleton
public class LogService {
    private static Logger logger = Logger.getLogger(LogService.class.getName());
    private int maxSize = 30;
    private List<String> logTopics;
    public static final int LOG_INFO = 1;
    public static final int LOG_WARNING = 2;
    public static final int LOG_ERROR = 3;

    private void add(int type, String message) {
        String pattern = " HH:mm:ss.SSSZ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        if (this.logTopics == null) {
            this.logTopics = new ArrayList();
        }
        while (this.logTopics.size() > this.maxSize) {
            this.logTopics.remove(0);
        }
        String entry = simpleDateFormat.format(new Date()) + " ";
        if (type == 3) {
            entry = entry + "[ERROR] ";
            logger.severe(message);
        } else if (type == 2) {
            entry = entry + "[WARNING] ";
            logger.warning(message);
        } else {
            entry = entry + "[INFO]    ";
            logger.info(message);
        }
        entry = entry + message;
        this.logTopics.add(entry);
    }

    public List<String> getLogEntries() {
        return this.logTopics;
    }

    public void info(String message) {
        this.add(1, message);
    }

    public void warning(String message) {
        this.add(2, message);
    }

    public void severe(String message) {
        this.add(3, message);
    }
}

