/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.export.controller;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.imixs.archive.export.ExportException;
import org.imixs.archive.export.services.ExportStatusHandler;
import org.imixs.archive.export.services.LogService;
import org.imixs.archive.export.services.SchedulerService;

@Named
@RequestScoped
public class ExportController
implements Serializable {
    private static final long serialVersionUID = 7027147503119012594L;
    @Inject
    @ConfigProperty(name="health.endpoint", defaultValue="http://localhost:9990/health")
    String healthEndpoint;
    @Inject
    @ConfigProperty(name="metrics.endpoint", defaultValue="http://localhost:9990/metrics")
    String metricsEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> instanceEndpoint;
    @Inject
    @ConfigProperty(name="export.ftp.host")
    Optional<String> ftpServer;
    @Inject
    @ConfigProperty(name="export.path")
    Optional<String> filePath;
    @Inject
    @ConfigProperty(name="export.ftp.port", defaultValue="21")
    int ftpPort;
    @Inject
    @ConfigProperty(name="workflow.sync.interval", defaultValue="1000")
    long interval;
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;
    private static Logger logger = Logger.getLogger(ExportController.class.getName());
    @Inject
    SchedulerService exportService;
    @Inject
    LogService logService;
    @Inject
    ExportStatusHandler exportStatusHandler;

    public String getHealthEndpoint() {
        return this.healthEndpoint;
    }

    public String getMetricsEndpoint() {
        return this.metricsEndpoint;
    }

    public boolean isConnected() {
        String status = this.exportStatusHandler.getStatus();
        return "RUNNING".equals(status) || "SCHEDULED".equals(status);
    }

    public String getStatus() {
        return this.exportStatusHandler.getStatus();
    }

    public Date getNextTimeout() {
        return this.exportStatusHandler.getNextTimeout();
    }

    public String getFtpServer() {
        return this.ftpServer.orElse("");
    }

    public String getFilePath() {
        return this.filePath.orElse("");
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public String getInstanceEndpoint() {
        return this.instanceEndpoint.orElse("");
    }

    public long getInterval() {
        return this.interval;
    }

    public void start() {
        try {
            this.exportService.startScheduler(true);
        }
        catch (ExportException e) {
            this.logService.warning(e.getMessage());
        }
    }

    public void stop() {
        try {
            this.exportService.stopScheduler();
        }
        catch (ExportException e) {
            this.logService.warning(e.getMessage());
        }
    }

    public long getCounterByName(String name) {
        SortedMap allCounters = this.metricRegistry.getCounters();
        for (Map.Entry entry : allCounters.entrySet()) {
            MetricID metricID = (MetricID)entry.getKey();
            if (!metricID.getName().endsWith(name)) continue;
            return ((Counter)entry.getValue()).getCount();
        }
        logger.fine("Metric Counter : " + name + " not found!");
        return 0L;
    }

    public List<String> getLogEntries() {
        return this.logService.getLogEntries();
    }
}

