/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.export.services;

import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.export.ExportException;
import org.imixs.archive.export.services.LogService;
import org.imixs.workflow.FileData;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
@LocalBean
public class FileService {
    private static Logger logger = Logger.getLogger(FileService.class.getName());
    public static final String FTP_ERROR = "FTP_ERROR";
    @Inject
    LogService logService;
    @Inject
    @ConfigProperty(name="export.ftp.host")
    Optional<String> ftpServer;
    @Inject
    @ConfigProperty(name="export.ftp.port")
    Optional<Integer> ftpPort;
    @Inject
    @ConfigProperty(name="export.ftp.user")
    Optional<String> ftpUser;
    @Inject
    @ConfigProperty(name="export.ftp.password")
    Optional<String> ftpPassword;
    @Inject
    @ConfigProperty(name="export.path")
    Optional<String> filePath;

    public void writeFileData(FileData fileData, String path) throws ExportException {
        Object workingPath = "";
        if (fileData == null) {
            throw new ExportException("EXPORT_EXCEPTION", "FileData object is null!");
        }
        if (path == null) {
            path = "";
        }
        workingPath = fileData.getName();
        try {
            String newChecksum = fileData.generateMD5();
            FileData oldFile = this.readFileData(fileData.getName(), path);
            if (oldFile != null && oldFile.generateMD5().equals(newChecksum)) {
                logger.info("file content unchanged: " + (String)workingPath);
                return;
            }
            if (this.ftpServer.isPresent()) {
                this.ftpPut(fileData, path);
            } else {
                workingPath = this.computeWorkingDirectory(path);
                Files.createDirectories(Paths.get((String)workingPath, new String[0]), new FileAttribute[0]);
                workingPath = (String)workingPath + fileData.getName();
                logger.info("write file content: " + (String)workingPath);
                Files.write(Paths.get((String)workingPath, new String[0]), fileData.getContent(), new OpenOption[0]);
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ExportException("EXPORT_EXCEPTION", "Unable to write file: " + (String)workingPath, e);
        }
    }

    public FileData readFileData(String fileName, String path) throws ExportException {
        FileData fileData = null;
        if (this.ftpServer.isPresent()) {
            fileData = this.ftpGet(fileName, path);
        } else {
            Object workingPath = this.computeWorkingDirectory(path);
            workingPath = (String)workingPath + fileName;
            logger.fine("...read file from: " + (String)workingPath);
            Path nioPath = Paths.get((String)workingPath, new String[0]);
            try {
                if (Files.exists(nioPath, new LinkOption[0])) {
                    byte[] data = Files.readAllBytes(nioPath);
                    fileData = new FileData(fileName, data, null, null);
                }
            }
            catch (IOException e) {
                throw new ExportException("EXPORT_EXCEPTION", "Unable to read file: " + (String)workingPath, (Exception)e);
            }
        }
        return fileData;
    }

    private FTPSClient getFTPClient() throws ExportException, SocketException, IOException {
        FTPSClient ftpClient = new FTPSClient("TLS", false);
        ftpClient.setControlEncoding("UTF-8");
        ftpClient.connect(this.ftpServer.orElse(""), this.ftpPort.orElse(21).intValue());
        if (!ftpClient.login(this.ftpUser.orElse(""), this.ftpPassword.orElse(""))) {
            throw new ExportException("FTP_ERROR", "FTP file transfer failed: login failed!");
        }
        ftpClient.enterLocalPassiveMode();
        ftpClient.setFileType(2);
        return ftpClient;
    }

    private void changeWorkingDirectory(FTPClient ftpClient, String subDirectory) throws ExportException {
        try {
            if (!ftpClient.changeWorkingDirectory(subDirectory)) {
                FileService.makeDirectoryPath((FTPClient)ftpClient, (String)subDirectory);
                ftpClient.changeWorkingDirectory(subDirectory);
            }
        }
        catch (IOException e) {
            throw new ExportException("FTP_ERROR", "FTP file transfer failed: " + e.getMessage(), (Exception)e);
        }
    }

    private static void makeDirectoryPath(FTPClient ftpClient, String dirPath) throws IOException, ExportException {
        String[] pathElements = dirPath.split("/");
        if (pathElements != null && pathElements.length > 0) {
            for (String singleDir : pathElements) {
                boolean existed;
                if (singleDir.isEmpty() || (existed = ftpClient.changeWorkingDirectory(singleDir))) continue;
                boolean created = ftpClient.makeDirectory(singleDir);
                if (created) {
                    ftpClient.changeWorkingDirectory(singleDir);
                    continue;
                }
                throw new ExportException("FTP_ERROR", "FTP file transfer failed - COULD NOT create directory: " + singleDir);
            }
        }
    }

    private void ftpPut(FileData fileData, String path) throws ExportException {
        if (!this.ftpServer.isPresent() || !this.filePath.isPresent()) {
            throw new ExportException("FTP_ERROR", "FTP file transfer failed: no ftp host provided (export.ftp.host)!");
        }
        String ftpWorkingPath = this.computeWorkingDirectory(path);
        InputStream writer = null;
        FTPSClient ftpClient = null;
        try {
            logger.info("put file content: " + fileData.getName() + " on FTP server...");
            ftpClient = this.getFTPClient();
            this.changeWorkingDirectory((FTPClient)ftpClient, ftpWorkingPath);
            writer = new ByteArrayInputStream(fileData.getContent());
            if (!ftpClient.storeFile(fileData.getName(), writer)) {
                throw new ExportException("FTP_ERROR", "FTP file transfer failed: unable to write '" + ftpWorkingPath + fileData.getName() + "' : " + ftpClient.getReplyString());
            }
            logger.finest("...." + ftpWorkingPath + fileData.getName() + " transferred successful to " + String.valueOf(this.ftpServer));
        }
        catch (IOException e) {
            throw new ExportException("FTP_ERROR", "FTP file transfer failed: " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (ftpClient != null) {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
            }
            catch (IOException e) {
                throw new ExportException("FTP_ERROR", "FTP file transfer failed: " + e.getMessage(), (Exception)e);
            }
        }
    }

    private FileData ftpGet(String fileName, String path) throws ExportException {
        long l = System.currentTimeMillis();
        if (!this.ftpServer.isPresent() || !this.filePath.isPresent()) {
            throw new ExportException("FTP_ERROR", "FTP file transfer failed: no ftp host provided (export.ftp.host)!");
        }
        String ftpWorkingPath = this.computeWorkingDirectory(path);
        ByteArrayOutputStream bos = null;
        FTPSClient ftpClient = null;
        try {
            ftpClient = this.getFTPClient();
            this.changeWorkingDirectory((FTPClient)ftpClient, ftpWorkingPath);
            logger.finest("......get " + fileName + "...");
            bos = new ByteArrayOutputStream();
            ftpClient.retrieveFile(fileName, (OutputStream)bos);
            byte[] result = bos.toByteArray();
            logger.finest("......" + fileName + " transferred successful from " + String.valueOf(this.ftpServer) + " in " + (System.currentTimeMillis() - l) + "ms");
            FileData fileData = new FileData(fileName, result, null, null);
            return fileData;
        }
        catch (IOException e) {
            throw new ExportException("FTP_ERROR", "FTP file transfer failed: " + e.getMessage(), (Exception)e);
        }
    }

    private String computeWorkingDirectory(String path) {
        Object ftpWorkingPath = this.filePath.orElse("");
        if (!((String)ftpWorkingPath).startsWith("/")) {
            ftpWorkingPath = "/" + (String)ftpWorkingPath;
        }
        if (path != null && !((String)path).isEmpty()) {
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            ftpWorkingPath = (String)ftpWorkingPath + (String)path;
        }
        if (!((String)ftpWorkingPath).endsWith("/")) {
            ftpWorkingPath = (String)ftpWorkingPath + "/";
        }
        return ftpWorkingPath;
    }
}

