/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.export.util;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.Cookie;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.CookieAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.JWTAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.melman.WorkflowClient;

@Named
@RequestScoped
public class RestClientHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> instanceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> instanceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> instancePassword;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> instanceAuthmethod;

    public DocumentClient getDocumentClient() throws RestAPIException {
        WorkflowClient documentClient = null;
        if (this.instanceEndpoint.isPresent()) {
            documentClient = new WorkflowClient((String)this.instanceEndpoint.get());
            String auttype = this.instanceAuthmethod.orElse("BASIC").toUpperCase();
            if ("BASIC".equals(auttype)) {
                BasicAuthenticator basicAuth = new BasicAuthenticator(this.instanceUser.orElse(""), this.instancePassword.orElse(""));
                documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
            }
            if ("FORM".equals(auttype)) {
                FormAuthenticator formAuth = new FormAuthenticator(this.instanceEndpoint.orElse(""), this.instanceUser.orElse(""), this.instancePassword.orElse(""));
                documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
            }
            if ("COOKIE".equals(auttype)) {
                Cookie cookie = new Cookie(this.instanceUser.orElse(""), this.instancePassword.orElse(""));
                CookieAuthenticator cookieAuth = new CookieAuthenticator(cookie);
                documentClient.registerClientRequestFilter((ClientRequestFilter)cookieAuth);
            }
            if ("JWT".equalsIgnoreCase(this.instancePassword.orElse(""))) {
                JWTAuthenticator jwtAuht = new JWTAuthenticator(this.instancePassword.orElse(""));
                documentClient.registerClientRequestFilter((ClientRequestFilter)jwtAuht);
            }
        }
        return documentClient;
    }

    public EventLogClient getEventLogClient(DocumentClient documentClient) {
        if (documentClient != null) {
            EventLogClient client = new EventLogClient(documentClient.getBaseURI());
            List filterList = documentClient.getRequestFilterList();
            for (ClientRequestFilter filter : filterList) {
                client.registerClientRequestFilter(filter);
            }
            return client;
        }
        return null;
    }
}

