/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.ftp;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@Stateless
public class CSVImportService {
    public static final String DATA_ERROR = "DATA_ERROR";
    public static final String IMPORT_ERROR = "IMPORT_ERROR";
    private static Logger logger = Logger.getLogger(CSVImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @Inject
    UpdateService indexUpdateService;
    @EJB
    DocumentService documentService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(@Observes DocumentImportEvent event) {
        block54: {
            FTPSClient ftpClient = null;
            if (event.getResult() == 1) {
                logger.finest("...... import source already completed - no processing will be performed.");
                return;
            }
            if (!"CSV".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
                logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skiped.");
                return;
            }
            try {
                String encoding;
                String ftpServer = event.getSource().getItemValueString("server");
                String ftpPort = event.getSource().getItemValueString("port");
                String ftpUser = event.getSource().getItemValueString("user");
                String ftpPassword = event.getSource().getItemValueString("password");
                String csvSelector = event.getSource().getItemValueString("selector");
                Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
                String type = sourceOptions.getProperty("type");
                if (type == null || type.isEmpty()) {
                    throw new PluginException(this.getClass().getName(), DATA_ERROR, "Missing property 'type' to import entities");
                }
                String keyField = sourceOptions.getProperty("key");
                if (keyField == null || keyField.isEmpty()) {
                    throw new PluginException(this.getClass().getName(), DATA_ERROR, "Missing property 'key' to import entities");
                }
                if (!keyField.startsWith("_")) {
                    keyField = "_" + keyField;
                }
                if ((encoding = sourceOptions.getProperty("encoding")) == null || encoding.isEmpty()) {
                    encoding = "UTF-8";
                }
                if (!csvSelector.startsWith("/") && !csvSelector.startsWith("./")) {
                    csvSelector = "/" + csvSelector;
                }
                if (!csvSelector.toLowerCase().endsWith(".csv")) {
                    this.documentImportService.logMessage("...invalid selector - .csv file path expected - " + csvSelector, event);
                }
                if (ftpServer.isEmpty()) {
                    logger.warning("...... no server specified!");
                    return;
                }
                if (ftpPort.isEmpty()) {
                    ftpPort = "21";
                }
                logger.finest("......read directories ...");
                this.documentImportService.logMessage("...csv import: " + csvSelector, event);
                this.documentImportService.logMessage("...connecting to FTP server: " + ftpServer, event);
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding(encoding);
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    this.documentImportService.logMessage("FTP file transfer failed: login failed!", event);
                    event.setResult(2);
                    return;
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=2");
                ftpClient.setFileType(2);
                ftpClient.setControlEncoding(encoding);
                File file = new File(csvSelector);
                String csvFTPPath = file.getParent();
                String csvFilename = file.getName();
                boolean bWorkingDir = ftpClient.changeWorkingDirectory(csvFTPPath);
                if (bWorkingDir) {
                    this.documentImportService.logMessage("...working directory: " + ftpClient.printWorkingDirectory(), event);
                    logger.info("import file " + csvFilename + "...");
                    try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                        ftpClient.retrieveFile(csvFilename, (OutputStream)is);
                        byte[] rawData = is.toByteArray();
                        if (rawData != null && rawData.length > 0) {
                            logger.finest("......file '" + file.getName() + "' successfull read - bytes size = " + rawData.length);
                            String lastChecksum = event.getSource().getItemValueString("csv.checksum");
                            FileData fileData = new FileData(file.getName(), rawData, null, null);
                            String newChecksum = fileData.generateMD5();
                            this.documentImportService.logMessage("...checksum=" + newChecksum, event);
                            if (lastChecksum.isEmpty() || !lastChecksum.equals(newChecksum)) {
                                ByteArrayInputStream imputStream = new ByteArrayInputStream(rawData);
                                String log = this.importData(imputStream, encoding, type, keyField, event);
                                event.getSource().setItemValue("csv.checksum", (Object)newChecksum);
                                this.documentImportService.logMessage(log, event);
                            } else {
                                this.documentImportService.logMessage("...no changes '" + file.getName() + "'", event);
                            }
                        } else {
                            this.documentImportService.logMessage("...Warning - invalid file content '" + file.getName() + "' - file will be deleted!", event);
                        }
                        break block54;
                    }
                    catch (NoSuchAlgorithmException | AccessDeniedException | PluginException | ProcessingErrorException e) {
                        this.documentImportService.logMessage("...FTP import failed: " + e.getMessage(), event);
                        event.setResult(2);
                        try {
                            ftpClient.logout();
                            ftpClient.disconnect();
                        }
                        catch (IOException e2) {
                            this.documentImportService.logMessage("...FTP file transfer failed: " + e2.getMessage(), event);
                            event.setResult(2);
                            return;
                        }
                        return;
                    }
                }
                this.documentImportService.logMessage("...failed to change into working directory: " + csvFTPPath, event);
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                int r = ftpClient.getReplyCode();
                logger.severe("FTP ReplyCode=" + r);
                this.documentImportService.logMessage("...FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), event);
                event.setResult(2);
                return;
            }
            catch (PluginException e) {
                logger.severe("Data Error: " + e.getMessage());
                e.printStackTrace();
                this.documentImportService.logMessage("...FTP csv import error  : " + e.getMessage(), event);
                event.setResult(2);
                return;
            }
            finally {
                try {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    this.documentImportService.logMessage("...FTP file transfer failed: " + e.getMessage(), event);
                    event.setResult(2);
                    return;
                }
            }
        }
        this.indexUpdateService.updateIndex();
        event.setResult(1);
    }

    public ItemCollection createWorkitem(ItemCollection source, String fileName, byte[] rawData) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("workflowmodel"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        String contentType = "*/*";
        if (fileName.toLowerCase().endsWith(".pdf")) {
            contentType = "Application/PDF";
        }
        FileData fileData = new FileData(fileName, rawData, contentType, null);
        workitem.addFileData(fileData);
        workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
        return workitem;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public String importData(InputStream imputStream, String encoding, String type, String keyField, DocumentImportEvent event) throws PluginException {
        logger.fine("...starting csv data import...");
        String log = "";
        int line = 0;
        String dataLine = null;
        ArrayList<String> idCache = new ArrayList<String>();
        int workitemsTotal = 0;
        int workitemsImported = 0;
        int workitemsUpdated = 0;
        int workitemsDeleted = 0;
        int workitemsFailed = 0;
        int blockSize = 0;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(imputStream, encoding));
            String header = in.readLine();
            List<String> fields = this.parseFieldList(header);
            if (fields == null || fields.size() == 0) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, 1st line must contain the item names.");
            }
            if (type == null || type.isEmpty()) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "Missing type to import entities");
            }
            logger.info("...object type=" + type);
            logger.info("...key field=" + keyField);
            ++line;
            while ((dataLine = in.readLine()) != null) {
                ++blockSize;
                ++line;
                ++workitemsTotal;
                ItemCollection entity = this.readEntity(dataLine, fields);
                String keyItemValue = entity.getItemValueString(keyField);
                entity.replaceItemValue("name", (Object)keyItemValue);
                if (idCache.contains(keyItemValue)) {
                    logger.warning("...WARNING dupplicate entry found: " + keyField + "=" + keyItemValue);
                    this.documentImportService.logMessage("...WARNING dupplicate entry found: " + keyField + "=" + keyItemValue, event);
                } else {
                    idCache.add(keyItemValue);
                }
                ItemCollection oldEntity = this.findEntityByName(entity.getItemValueString("Name"), type);
                if (oldEntity == null) {
                    this.saveEntry(entity, type);
                    ++workitemsImported;
                } else if (!this.isEqualEntity(oldEntity, entity, fields)) {
                    logger.fine("update exsting entity: " + oldEntity.getUniqueID());
                    oldEntity.replaceAllItems(entity.getAllItems());
                    this.saveEntry(oldEntity, type);
                    ++workitemsUpdated;
                }
                if (blockSize < 100) continue;
                blockSize = 0;
                logger.info(workitemsTotal + " entries read....");
            }
            logger.info("completed: " + workitemsTotal + " entries successful read");
        }
        catch (Exception e) {
            ++workitemsFailed;
            String sError = "import error at line " + line + ": " + e + " data=" + dataLine;
            logger.severe(sError);
            throw new PluginException(CSVImportService.class.getName(), DATA_ERROR, sError, e);
        }
        finally {
            try {
                if (imputStream != null) {
                    imputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        workitemsDeleted = this.removeDeprecatedDocuments(idCache, type);
        log = log + "..." + workitemsTotal + " entries read -> " + workitemsImported + " new entries - " + workitemsUpdated + " updates - " + workitemsDeleted + " deletions - " + workitemsFailed + " errors";
        logger.info(log);
        return log;
    }

    private int removeDeprecatedDocuments(List<String> idCache, String type) {
        int deletions = 0;
        int firstResult = 0;
        int blockSize = 100;
        logger.info("removing deprecated entries...");
        String sQuery = "SELECT document FROM Document AS document WHERE document.type='" + type + "' ORDER BY document.created ASC";
        while (true) {
            List entries = this.documentService.getDocumentsByQuery(sQuery, firstResult, blockSize);
            for (ItemCollection entity : entries) {
                String id = entity.getItemValueString("name");
                if (idCache.contains(id)) continue;
                this.documentService.remove(entity);
                ++deletions;
            }
            if (entries.size() != blockSize) break;
            firstResult += blockSize;
        }
        return deletions;
    }

    private ItemCollection readEntity(String data, List<String> fieldnames) {
        ItemCollection result = new ItemCollection();
        int iCol = 0;
        String[] valuList = data.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
        for (String itemValue : valuList = this.normalizeValueList(valuList)) {
            if ((itemValue = itemValue.trim()) != null && !itemValue.isEmpty()) {
                result.replaceItemValue(fieldnames.get(iCol), (Object)itemValue);
            } else {
                result.replaceItemValue(fieldnames.get(iCol), (Object)"");
            }
            if (++iCol >= fieldnames.size()) break;
        }
        return result;
    }

    private String[] normalizeValueList(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            String value = data[i];
            if (!value.startsWith("\"") || !value.endsWith("\"")) continue;
            data[i] = value = value.substring(1, value.length() - 1);
        }
        return data;
    }

    private List<String> parseFieldList(String data) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (!field.isEmpty()) {
                field = field.replace("\"", "");
                field = field.replace("'", "");
                field = field.replace(".", "");
                field = field.replace(' ', '_');
                field = field.replace('/', '_');
                field = field.replace('\\', '_');
                field = field.replace('.', '_');
                field = field.replace('>', '_');
                field = field.replace('<', '_');
                field = field.replace('&', '_');
                result.add("_" + field.trim());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void saveEntry(ItemCollection aWorkitem, String type) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        aWorkitem.replaceItemValue("type", (Object)type);
        this.documentService.save(aWorkitem);
    }

    private boolean isEqualEntity(ItemCollection oldEntity, ItemCollection entity, List<String> fields) {
        for (String itemName : fields) {
            if (entity.getItemValue(itemName).equals(oldEntity.getItemValue(itemName))) continue;
            return false;
        }
        return true;
    }

    public ItemCollection findEntityByName(String key, String type) {
        String searchTerm = "(type:\"" + type + "\" AND name:\"" + key + "\")";
        try {
            List col = this.documentService.find(searchTerm, 1, 0);
            if (col.size() > 0) {
                return (ItemCollection)col.iterator().next();
            }
        }
        catch (QueryException e) {
            logger.warning(e.getMessage());
        }
        return null;
    }
}

