/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.archive.importer.mail.MailMessageService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@Stateless
public class IMAPImportService {
    public static final String OPTION_ARCHIVE_FOLDER = "archive.folder";
    public static final String OPTION_SUBJECT_REGEX = "subject.regex";
    public static final String OPTION_DETACH_MODE = "detach.mode";
    public static final String OPTION_PRESERVE_ORIGIN = "preserve.origin";
    public static final String OPTION_GOTENBERG_SERVICE = "gotenberg.service";
    public static final String DETACH_MODE_PDF = "PDF";
    public static final String DETACH_MODE_ALL = "ALL";
    public static final String DETACH_MODE_NONE = "NONE";
    public static final String ARCHIVE_DEFAULT_NAME = "imixs-archive";
    public static final String DEFAULT_NO_SUBJECT = "no subject";
    private static Logger logger = Logger.getLogger(IMAPImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;
    @EJB
    MailMessageService mailMessageService;

    public void onEvent(@Observes DocumentImportEvent event) {
        if (event.getResult() == 1) {
            logger.finest("...... import source already completed - no processing will be performed.");
            return;
        }
        if (!"IMAP".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
            logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skiped.");
            return;
        }
        String imapServer = event.getSource().getItemValueString("server");
        String imapPort = event.getSource().getItemValueString("port");
        String imapUser = event.getSource().getItemValueString("user");
        String imapPassword = event.getSource().getItemValueString("password");
        String imapFolder = event.getSource().getItemValueString("selector");
        Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
        Pattern subjectPattern = null;
        String subjectRegex = sourceOptions.getProperty(OPTION_SUBJECT_REGEX, "");
        if (subjectRegex != null && !subjectRegex.trim().isEmpty()) {
            try {
                subjectPattern = Pattern.compile(subjectRegex);
                this.documentImportService.logMessage("...subject.regex = " + subjectRegex, event);
            }
            catch (PatternSyntaxException e) {
                this.documentImportService.logMessage("Invalid IMAP regex filter: " + e.getMessage(), event);
                return;
            }
        }
        if (imapPort.isEmpty()) {
            imapPort = "993";
        }
        if (imapFolder.isEmpty()) {
            imapFolder = "INBOX";
        }
        try {
            Properties imapProperties = new Properties();
            imapProperties.setProperty("mail.store.protocol", "imaps");
            Enumeration<?> enums = sourceOptions.propertyNames();
            while (enums.hasMoreElements()) {
                String key = (String)enums.nextElement();
                if (!key.startsWith("mail.")) continue;
                imapProperties.setProperty(key, sourceOptions.getProperty(key));
                logger.info("......setting property from source options: " + key);
            }
            if (imapProperties.containsKey("mail.imap.port")) {
                imapPort = imapProperties.getProperty("mail.imap.port");
            }
            Session session = Session.getDefaultInstance((Properties)imapProperties, null);
            Store store = session.getStore();
            this.documentImportService.logMessage("...connecting to IMAP server: " + imapServer + ":" + imapPort + " /" + imapFolder, event);
            store.connect(imapServer, Integer.parseInt(imapPort), imapUser, imapPassword);
            IMAPFolder inbox = (IMAPFolder)store.getFolder(imapFolder);
            inbox.open(2);
            String detachOption = sourceOptions.getProperty(OPTION_DETACH_MODE, DETACH_MODE_PDF);
            this.documentImportService.logMessage("...detach.mode = " + detachOption, event);
            IMAPFolder archiveFolder = this.openImapArchive(store, inbox, sourceOptions, event);
            Message[] messages = inbox.getMessages();
            this.documentImportService.logMessage("..." + messages.length + " new messages found", event);
            for (Message message : messages) {
                Object contentObject;
                Address[] fromAddress = message.getFrom();
                String subject = message.getSubject();
                if (subject == null || subject.trim().isEmpty()) {
                    subject = DEFAULT_NO_SUBJECT;
                }
                Date sent = message.getSentDate();
                logger.fine("......received mail from: " + fromAddress[0].toString());
                logger.fine("......subject = " + subject);
                if (subjectPattern != null) {
                    if (subject == null || DEFAULT_NO_SUBJECT.equals(subject)) continue;
                    Matcher subjectMatcher = subjectPattern.matcher(subject);
                    if (subjectMatcher == null) {
                        logger.finest("matcher is null!");
                        continue;
                    }
                    if (!subjectMatcher.find()) {
                        continue;
                    }
                } else {
                    logger.finest("...no regex pattern mail will be processed...");
                }
                ItemCollection workitem = this.createWorkitem(event.getSource());
                if (fromAddress[0] instanceof InternetAddress) {
                    InternetAddress internetAddr = (InternetAddress)fromAddress[0];
                    workitem.setItemValue("mail.from", (Object)internetAddr.getAddress());
                    workitem.setItemValue("mail.from.personal", (Object)internetAddr.getPersonal());
                } else {
                    workitem.setItemValue("mail.from", (Object)fromAddress[0].toString());
                }
                workitem.setItemValue("mail.subject", (Object)subject);
                workitem.setItemValue("mail.sent", (Object)sent);
                if (!DETACH_MODE_NONE.equals(detachOption) && (contentObject = message.getContent()) instanceof Multipart) {
                    Multipart multiPart = (Multipart)message.getContent();
                    for (int i = 0; i < multiPart.getCount(); ++i) {
                        MimeBodyPart mimeBodyPart;
                        BodyPart bodyPart = multiPart.getBodyPart(i);
                        if (!(bodyPart instanceof MimeBodyPart) || !"attachment".equalsIgnoreCase((mimeBodyPart = (MimeBodyPart)multiPart.getBodyPart(i)).getDisposition())) continue;
                        String fileName = mimeBodyPart.getFileName();
                        if (fileName == null) {
                            logger.info("...skip because of missing filename");
                            continue;
                        }
                        if (DETACH_MODE_PDF.equals(detachOption) && !fileName.toLowerCase().endsWith(".pdf")) continue;
                        InputStream input = mimeBodyPart.getInputStream();
                        byte[] content = IMAPImportService.readAllBytes(input);
                        String contentType = mimeBodyPart.getContentType();
                        logger.info("mimetype=" + contentType);
                        if (contentType.contains("application/octet-stream") && fileName.toLowerCase().endsWith(".pdf")) {
                            logger.info("converting mimetype to application/pdf");
                            contentType = "application/pdf";
                        }
                        if (contentType.contains(";")) {
                            contentType = contentType.substring(0, contentType.indexOf(";"));
                        }
                        FileData fileData = new FileData(fileName, content, contentType, null);
                        workitem.addFileData(fileData);
                    }
                }
                if (DETACH_MODE_ALL.equals(detachOption)) {
                    String gotenbergService = sourceOptions.getProperty(OPTION_GOTENBERG_SERVICE);
                    if (gotenbergService != null && !gotenbergService.isEmpty()) {
                        try {
                            logger.info("using gotenbergservice: " + gotenbergService);
                            this.mailMessageService.attachPDFMessage(message, workitem, gotenbergService);
                        }
                        catch (IOException eio) {
                            this.documentImportService.logMessage("... connectiong to gotenberg service '" + gotenbergService + "' failed: " + eio.getMessage() + " message will be added in HTML format!", event);
                            this.mailMessageService.attachHTMLMessage(message, workitem);
                        }
                    } else {
                        this.mailMessageService.attachHTMLMessage(message, workitem);
                    }
                    String preserveOrigin = sourceOptions.getProperty(OPTION_PRESERVE_ORIGIN, "true");
                    if (preserveOrigin != null && "true".equalsIgnoreCase(preserveOrigin)) {
                        this.mailMessageService.attachMessage(message, workitem);
                    }
                }
                if (!DETACH_MODE_ALL.equalsIgnoreCase(detachOption)) {
                    this.mailMessageService.attachMessage(message, workitem);
                }
                workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
                Message[] messageList = new Message[]{message};
                inbox.moveMessages(messageList, (Folder)archiveFolder);
            }
            logger.finest("...completed");
        }
        catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
            this.documentImportService.logMessage("IMAP import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
        catch (IOException | MessagingException e) {
            this.documentImportService.logMessage("IMAP import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
    }

    private IMAPFolder openImapArchive(Store store, IMAPFolder inbox, Properties sourceOptions, DocumentImportEvent event) throws MessagingException {
        String imapArchiveFolder = sourceOptions.getProperty(OPTION_ARCHIVE_FOLDER, ARCHIVE_DEFAULT_NAME);
        this.documentImportService.logMessage("...archive.folder = " + imapArchiveFolder, event);
        IMAPFolder archive = (IMAPFolder)inbox.getFolder(imapArchiveFolder);
        if (!archive.exists()) {
            logger.info("...creating folder '" + imapArchiveFolder + "'");
            boolean isCreated = archive.create(1);
            if (isCreated) {
                logger.info("...folder sucessfull created");
            } else {
                logger.info("...failed to create new archvie folder!");
            }
        }
        archive.open(2);
        return archive;
    }

    public ItemCollection createWorkitem(ItemCollection source) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("workflowmodel"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        return workitem;
    }

    /*
     * Exception decompiling
     */
    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

