/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.faces.view.ViewScoped;
import javax.inject.Named;
import org.imixs.archive.importer.DocumentImportScheduler;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.scheduler.SchedulerController;
import org.imixs.workflow.engine.scheduler.SchedulerService;

@Named
@ViewScoped
public class DocumentImportController
extends SchedulerController {
    private static final long serialVersionUID = 1L;
    protected List<ItemCollection> sources = null;
    protected ItemCollection source = null;
    @EJB
    SchedulerService schedulerService;
    @EJB
    DocumentImportService documentImportService;
    private static Logger logger = Logger.getLogger(DocumentImportController.class.getName());

    @PostConstruct
    public void init() {
        super.init();
        this.sources = this.documentImportService.loadSourcesFromConfiguration(this.getConfiguration());
    }

    public String getName() {
        return "DOCUMENT_IMPORTER";
    }

    public String getSchedulerClass() {
        return DocumentImportScheduler.class.getName();
    }

    public void saveConfiguration() {
        ItemCollection config = this.getConfiguration();
        ArrayList<Map> mapItemList = new ArrayList<Map>();
        if (this.sources != null) {
            logger.fine("Convert option items into Map...");
            for (ItemCollection orderItem : this.sources) {
                mapItemList.add(orderItem.getAllItems());
            }
            config.replaceItemValue("sources", mapItemList);
        }
        super.saveConfiguration();
    }

    public List<ItemCollection> getSources() {
        return this.sources;
    }

    public void setSources(List<ItemCollection> sources) {
        this.sources = sources;
    }

    public ItemCollection getSource() {
        return this.source;
    }

    public void setSource(ItemCollection source) {
        this.source = source;
    }

    public void addSource() {
        if (this.sources == null) {
            this.sources = new ArrayList<ItemCollection>();
        }
        this.source = new ItemCollection();
        this.source.setItemValue("index", (Object)this.sources.size());
        this.sources.add(this.source);
    }

    public void selectSource(int index) {
        if (this.sources != null) {
            this.source = this.sources.get(index);
        }
    }

    public void removeSource(int index) {
        if (this.sources != null) {
            this.sources.remove(index);
        }
    }

    public void moveSourceDown(int index) {
        if (this.sources != null && index < this.sources.size() - 1) {
            this.source = this.sources.get(index);
            this.sources.remove(index);
            this.sources.add(index + 1, this.source);
            int iPos = 0;
            for (ItemCollection item : this.sources) {
                item.setItemValue("index", (Object)iPos);
                ++iPos;
            }
        }
    }

    public void moveSourceUp(int index) {
        if (this.sources != null && index > 0) {
            this.source = this.sources.get(index);
            this.sources.remove(index);
            this.sources.add(index - 1, this.source);
            int iPos = 0;
            for (ItemCollection item : this.sources) {
                item.setItemValue("index", (Object)iPos);
                ++iPos;
            }
        }
    }
}

