/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer;

import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.scheduler.Scheduler;
import org.imixs.workflow.engine.scheduler.SchedulerException;

public class DocumentImportScheduler
implements Scheduler {
    public static final String DOCUMENT_IMPORTER_NAME = "DOCUMENT_IMPORTER";
    @EJB
    DocumentImportService documentImportService;
    @Inject
    protected Event<DocumentImportEvent> importEvents;
    private static Logger logger = Logger.getLogger(DocumentImportScheduler.class.getName());

    public ItemCollection run(ItemCollection configuration) throws SchedulerException {
        if (this.importEvents != null) {
            List<ItemCollection> sources = this.documentImportService.loadSourcesFromConfiguration(configuration);
            if (sources.size() > 0) {
                this.documentImportService.logMessage("Document import starting - " + sources.size() + " sources found...", configuration);
                for (ItemCollection source : sources) {
                    DocumentImportEvent importEvent = new DocumentImportEvent(source);
                    this.importEvents.fire((Object)importEvent);
                    configuration.appendItemValue("_scheduler_logmessage", importEvent.getMessages());
                    if (importEvent.getResult() != 2) continue;
                    logger.severe("...Document Import Error");
                }
                this.documentImportService.logMessage("Document import completed.", configuration);
            } else {
                this.documentImportService.logMessage("No sources defined.", configuration);
                return configuration;
            }
        }
        return configuration;
    }
}

