/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.WorkflowService;

@Stateless
@LocalBean
public class DocumentImportService {
    public static final String ITEM_SOURCES = "sources";
    public static final String SOURCE_ITEM_SERVER = "server";
    public static final String SOURCE_ITEM_PORT = "port";
    public static final String SOURCE_ITEM_USER = "user";
    public static final String SOURCE_ITEM_PASSWORD = "password";
    public static final String SOURCE_ITEM_TASK = "task";
    public static final String SOURCE_ITEM_EVENT = "event";
    public static final String SOURCE_ITEM_WORKFLOWGROUP = "workflowgroup";
    public static final String SOURCE_ITEM_MODELVERSION = "modelversion";
    public static final String SOURCE_ITEM_SELECTOR = "selector";
    public static final String SOURCE_ITEM_OPTIONS = "options";
    private static Logger logger = Logger.getLogger(DocumentImportService.class.getName());
    @EJB
    WorkflowService workflowService;

    public List<ItemCollection> loadSourcesFromConfiguration(ItemCollection configuration) {
        ArrayList<ItemCollection> sources = new ArrayList<ItemCollection>();
        List mapItems = configuration.getItemValue(ITEM_SOURCES);
        for (Object mapOderItem : mapItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            sources.add(itemCol);
        }
        return sources;
    }

    public void logMessage(String message, DocumentImportEvent event) {
        if (event != null) {
            event.appendMessage(message);
        }
        logger.info(message);
    }

    public void logMessage(String message, ItemCollection config) {
        if (config != null) {
            config.appendItemValueUnique("_scheduler_logmessage", (Object)message);
        }
        logger.info(message);
    }

    public Properties getOptionsProperties(ItemCollection source) {
        Properties properties = new Properties();
        String optionsText = source.getItemValueString(SOURCE_ITEM_OPTIONS);
        String[] options = optionsText.split("\n");
        logger.fine("...read source properties");
        for (String sProperty : options) {
            int ipos = (sProperty = sProperty.replace("\r", "")).indexOf(61);
            if (ipos <= 0) continue;
            String sKey = sProperty.substring(0, sProperty.indexOf(61));
            String sValue = sProperty.substring(sProperty.indexOf(61) + 1);
            properties.setProperty(sKey.trim(), sValue.trim());
        }
        return properties;
    }
}

