/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.ftp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@Stateless
public class FTPImportService {
    private static Logger logger = Logger.getLogger(FTPImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(@Observes DocumentImportEvent event) {
        block43: {
            if (event.getResult() == 1) {
                logger.finest("...... import source already completed - no processing will be performed.");
                return;
            }
            if (!"FTP".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
                logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skiped.");
                return;
            }
            String ftpServer = event.getSource().getItemValueString("server");
            String ftpPort = event.getSource().getItemValueString("port");
            String ftpUser = event.getSource().getItemValueString("user");
            String ftpPassword = event.getSource().getItemValueString("password");
            String ftpPath = event.getSource().getItemValueString("selector");
            if (!ftpPath.startsWith("/")) {
                ftpPath = "/" + ftpPath;
            }
            if (!ftpPath.endsWith("/")) {
                ftpPath = ftpPath + "/";
            }
            if (ftpServer.isEmpty()) {
                logger.warning("...... no server specified!");
                return;
            }
            if (ftpPort.isEmpty()) {
                ftpPort = "21";
            }
            FTPSClient ftpClient = null;
            try {
                logger.finest("......read directories ...");
                this.documentImportService.logMessage("...connecting to FTP server: " + ftpServer, event);
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding("UTF-8");
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    this.documentImportService.logMessage("FTP file transfer failed: login failed!", event);
                    event.setResult(2);
                    return;
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=2");
                ftpClient.setFileType(2);
                ftpClient.setControlEncoding("UTF-8");
                logger.finest("......scan files from: " + ftpPath);
                FTPFile[] allFiles = ftpClient.listFiles(ftpPath);
                int count = 0;
                if (allFiles.length > 0) {
                    this.documentImportService.logMessage("..." + allFiles.length + " files found ", event);
                    for (FTPFile file : allFiles) {
                        if (!file.isFile()) {
                            this.documentImportService.logMessage("...'" + file.getName() + "' os not a valid file, object will be ignored!", event);
                            continue;
                        }
                        logger.info("import file " + file.getName() + "...");
                        String fullFileName = ftpPath + "/" + file.getName();
                        try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                            ftpClient.retrieveFile(fullFileName, (OutputStream)is);
                            byte[] rawData = is.toByteArray();
                            if (rawData != null && rawData.length > 0) {
                                logger.finest("......file '" + file.getName() + "' successfull read - bytes size = " + rawData.length);
                                this.createWorkitem(event.getSource(), file.getName(), rawData);
                                this.documentImportService.logMessage("....imported '" + file.getName() + "'", event);
                                ++count;
                            } else {
                                this.documentImportService.logMessage("...Warning - invalid file content '" + file.getName() + "' - file will be deleted!", event);
                            }
                            ftpClient.deleteFile(fullFileName);
                        }
                        catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
                            this.documentImportService.logMessage("...FTP import failed: " + e.getMessage(), event);
                            event.setResult(2);
                            try {
                                ftpClient.logout();
                                ftpClient.disconnect();
                            }
                            catch (IOException e2) {
                                this.documentImportService.logMessage("...FTP file transfer failed: " + e2.getMessage(), event);
                                event.setResult(2);
                                return;
                            }
                            return;
                        }
                    }
                    this.documentImportService.logMessage("..." + count + " new files imported.", event);
                    break block43;
                }
                this.documentImportService.logMessage("...no files found, directory '" + ftpPath + "' is empty", event);
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                int r = ftpClient.getReplyCode();
                logger.severe("FTP ReplyCode=" + r);
                this.documentImportService.logMessage("...FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), event);
                event.setResult(2);
                return;
            }
            finally {
                try {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    this.documentImportService.logMessage("...FTP file transfer failed: " + e.getMessage(), event);
                    event.setResult(2);
                    return;
                }
            }
        }
        event.setResult(1);
    }

    public ItemCollection createWorkitem(ItemCollection source, String fileName, byte[] rawData) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("modelversion"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        String contentType = "*/*";
        if (fileName.toLowerCase().endsWith(".pdf")) {
            contentType = "Application/PDF";
        }
        FileData fileData = new FileData(fileName, rawData, contentType, null);
        workitem.addFileData(fileData);
        workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
        return workitem;
    }
}

