/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.event.Observes;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeBodyPart;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.archive.importer.mail.MailMessageService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@Stateless
public class IMAPImportService {
    public static final String DETACH_MODE_PDF = "PDF";
    public static final String DETACH_MODE_ALL = "ALL";
    public static final String DETACH_MODE_NONE = "NONE";
    public static final String ARCHIVE_DEFAULT_NAME = "imixs-archive";
    private static Logger logger = Logger.getLogger(IMAPImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;
    @EJB
    MailMessageService mailMessageService;

    public void onEvent(@Observes DocumentImportEvent event) {
        if (event.getResult() == 1) {
            logger.finest("...... import source already completed - no processing will be performed.");
            return;
        }
        if (!"IMAP".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
            logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skiped.");
            return;
        }
        String imapServer = event.getSource().getItemValueString("server");
        String imapPort = event.getSource().getItemValueString("port");
        String imapUser = event.getSource().getItemValueString("user");
        String imapPassword = event.getSource().getItemValueString("password");
        String imapFolder = event.getSource().getItemValueString("selector");
        if (imapPort.isEmpty()) {
            imapPort = "993";
        }
        if (imapFolder.isEmpty()) {
            imapFolder = "INBOX";
        }
        try {
            Properties props = System.getProperties();
            props.setProperty("mail.store.protocol", "imaps");
            Session session = Session.getDefaultInstance((Properties)props, null);
            Store store = session.getStore("imaps");
            this.documentImportService.logMessage("...connecting to IMAP server: " + imapServer + " : " + imapFolder, event);
            store.connect(imapServer, new Integer(imapPort).intValue(), imapUser, imapPassword);
            IMAPFolder inbox = (IMAPFolder)store.getFolder(imapFolder);
            inbox.open(2);
            Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
            String detachOption = sourceOptions.getProperty("DETACH_MODE", DETACH_MODE_PDF);
            this.documentImportService.logMessage("...DETACH_MODE = " + detachOption, event);
            IMAPFolder archiveFolder = this.openImapArchive(store, inbox, sourceOptions, event);
            Message[] messages = inbox.getMessages();
            this.documentImportService.logMessage("..." + messages.length + " new messages found", event);
            for (Message message : messages) {
                Address[] fromAddress = message.getFrom();
                logger.finest("......receifed mail from: " + fromAddress[0].toString());
                ItemCollection workitem = this.createWorkitem(event.getSource());
                if (!DETACH_MODE_NONE.equals(detachOption)) {
                    Multipart multiPart = (Multipart)message.getContent();
                    for (int i = 0; i < multiPart.getCount(); ++i) {
                        MimeBodyPart part = (MimeBodyPart)multiPart.getBodyPart(i);
                        if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                        String fileName = part.getFileName();
                        if (DETACH_MODE_PDF.equals(detachOption) && !fileName.toLowerCase().endsWith(".pdf")) continue;
                        InputStream input = part.getInputStream();
                        byte[] content = IMAPImportService.readAllBytes(input);
                        FileData fileData = new FileData(fileName, content, part.getContentType(), null);
                        workitem.addFileData(fileData);
                    }
                }
                if (DETACH_MODE_ALL.equals(detachOption)) {
                    String gotenbergService = sourceOptions.getProperty("GOTENBERG_SERVICE");
                    if (gotenbergService != null && !gotenbergService.isEmpty()) {
                        try {
                            logger.info("using gotenbergservice: " + gotenbergService);
                            this.mailMessageService.attachPDFMessage(message, workitem, gotenbergService);
                        }
                        catch (IOException eio) {
                            this.documentImportService.logMessage("... connectiong to gotenberg service '" + gotenbergService + "' failed: " + eio.getMessage() + " message will be added in HTML format!", event);
                            this.mailMessageService.attachHTMLMessage(message, workitem);
                        }
                    } else {
                        this.mailMessageService.attachHTMLMessage(message, workitem);
                    }
                }
                if (!DETACH_MODE_ALL.equals(detachOption)) {
                    this.mailMessageService.attachMessage(message, workitem);
                }
                workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
                Message[] messageList = new Message[]{message};
                inbox.moveMessages(messageList, (Folder)archiveFolder);
            }
            this.documentImportService.logMessage("finished", event);
        }
        catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
            this.documentImportService.logMessage("IMAP import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
        catch (IOException | MessagingException e) {
            this.documentImportService.logMessage("IMAP import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
    }

    private IMAPFolder openImapArchive(Store store, IMAPFolder inbox, Properties sourceOptions, DocumentImportEvent event) throws MessagingException {
        String imapArchiveFolder = sourceOptions.getProperty("ARCHIVE_FOLDER", ARCHIVE_DEFAULT_NAME);
        this.documentImportService.logMessage("...ARCHIVE_FOLDER = " + imapArchiveFolder, event);
        IMAPFolder archive = (IMAPFolder)inbox.getFolder(imapArchiveFolder);
        if (!archive.exists()) {
            logger.info("...creating folder '" + imapArchiveFolder + "'");
            boolean isCreated = archive.create(1);
            if (isCreated) {
                logger.info("...folder sucessfull created");
            } else {
                logger.info("...failed to create new archvie folder!");
            }
        }
        archive.open(2);
        return archive;
    }

    public ItemCollection createWorkitem(ItemCollection source) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("workflowmodel"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        return workitem;
    }

    /*
     * Exception decompiling
     */
    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

