/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class GotenbergClient {
    private static final String LINE_FEED = "\r\n";

    public static byte[] convertHTML(String gotenbertEndpoint, InputStream inputStream) throws IOException {
        ByteArrayOutputStream bout;
        InputStream in;
        String boundary = "------------------------" + System.currentTimeMillis();
        if (!gotenbertEndpoint.endsWith("/")) {
            gotenbertEndpoint = gotenbertEndpoint + "/";
        }
        URL url = new URL(gotenbertEndpoint + "convert/html");
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setUseCaches(false);
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream outputStream = httpConn.getOutputStream();
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), true);
        writer.append("--" + boundary).append(LINE_FEED);
        writer.append("Content-Disposition: form-data; name=\"fileUpload\"; filename=\"index.html\"").append(LINE_FEED);
        writer.append("Content-Type: text/html").append(LINE_FEED);
        writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        writer.append(LINE_FEED);
        writer.flush();
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.flush();
        inputStream.close();
        writer.append(LINE_FEED);
        writer.flush();
        writer.append("--" + boundary + "--").append(LINE_FEED);
        writer.close();
        int status = httpConn.getResponseCode();
        System.out.println("http con response code=" + status);
        if (status == 200) {
            int length;
            in = null;
            bout = new ByteArrayOutputStream();
            in = httpConn.getInputStream();
            byte[] block = new byte[1024];
            while ((length = in.read(block)) != -1) {
                bout.write(block, 0, length);
            }
        } else {
            throw new IOException("Server connection failed - status: " + status);
        }
        in.close();
        byte[] pdfResult = bout.toByteArray();
        httpConn.disconnect();
        return pdfResult;
    }
}

