/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import jakarta.ejb.EJB;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.imixs.archive.importer.mail.GotenbergClient;
import org.imixs.archive.importer.mail.MailConverterService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;

@Stateless
@LocalBean
public class MailMessageService {
    @EJB
    MailConverterService mailConverterService;
    private static Logger logger = Logger.getLogger(MailMessageService.class.getName());

    public void attachHTMLMessage(Message message, ItemCollection workitem) throws IOException, MessagingException {
        logger.fine("...attach message as html file...");
        String htmlMessage = this.mailConverterService.convertToHTML(message);
        if (htmlMessage != null) {
            String filename = message.getSubject() + ".html";
            FileData fileData = new FileData(filename, htmlMessage.getBytes("UTF-8"), "text/html", null);
            workitem.addFileData(fileData);
        }
    }

    public void attachPDFMessage(Message message, ItemCollection workitem, String gotebergServiceEndpoint) throws IOException, MessagingException {
        byte[] pdfContent;
        logger.fine("...attach message as html file...");
        String htmlMessage = this.mailConverterService.convertToHTML(message);
        if (htmlMessage != null && (pdfContent = GotenbergClient.convertHTML("http://gotenberg:3000/", new ByteArrayInputStream(htmlMessage.getBytes(StandardCharsets.UTF_8)))) != null) {
            String filename = message.getSubject() + ".pdf";
            FileData fileData = new FileData(filename, pdfContent, "application/pdf", null);
            workitem.addFileData(fileData);
        }
    }

    public void attachMessage(Message message, ItemCollection workitem) throws IOException, MessagingException {
        logger.fine("...attach message as eml file...");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        message.writeTo((OutputStream)baos);
        String filename = message.getSubject() + ".eml";
        FileData fileData = new FileData(filename, baos.toByteArray(), "message/rfc822", null);
        workitem.addFileData(fileData);
    }
}

