/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import jakarta.inject.Named;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.imixs.archive.importer.mail.IMAPAuthenticator;
import org.imixs.archive.importer.mail.IMAPImportHelper;
import org.imixs.workflow.ItemCollection;

@Named
public class IMAPOutlookAuthenticator
implements IMAPAuthenticator,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(IMAPOutlookAuthenticator.class.getName());

    @Override
    public Store openMessageStore(ItemCollection sourceConfig, Properties sourceOptions) throws MessagingException {
        String imapServer = sourceConfig.getItemValueString("server");
        String imapPort = sourceConfig.getItemValueString("port");
        String imapUser = sourceConfig.getItemValueString("user");
        String imapPassword = sourceConfig.getItemValueString("password");
        boolean debug = Boolean.getBoolean(sourceOptions.getProperty("debug", "false"));
        Properties imapProperties = new Properties();
        Enumeration<?> enums = sourceOptions.propertyNames();
        while (enums.hasMoreElements()) {
            String key = (String)enums.nextElement();
            if (!key.startsWith("mail.")) continue;
            imapProperties.setProperty(key, sourceOptions.getProperty(key));
            if (!debug) continue;
            logger.info("......setting property from source options: " + key);
        }
        if (imapProperties.containsKey("mail.imap.port")) {
            imapPort = imapProperties.getProperty("mail.imap.port");
        }
        if (imapPort.isEmpty()) {
            imapPort = "993";
        }
        imapProperties.put("mail.store.protocol", "imap");
        imapProperties.put("mail.imap.host", "outlook.office365.com");
        imapProperties.put("mail.imap.port", imapPort);
        imapProperties.put("mail.imap.ssl.enable", "true");
        imapProperties.put("mail.imap.starttls.enable", "true");
        imapProperties.put("mail.imap.auth", "true");
        imapProperties.put("mail.imap.auth.mechanisms", "XOAUTH2");
        imapProperties.put("mail.imap.user", imapUser);
        String tenantId = sourceOptions.getProperty("microsoft.tenantid");
        String clientId = sourceOptions.getProperty("microsoft.clientid");
        String token = null;
        Store store = null;
        try {
            token = this.getAuthToken(tenantId, clientId, imapPassword);
            Session session = Session.getInstance((Properties)imapProperties);
            if (debug) {
                session.setDebug(true);
            }
            store = session.getStore("imap");
            store.connect("outlook.office365.com", imapUser, token);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("Failed to connect: " + e.getMessage());
        }
        return store;
    }

    public String getAuthToken(String tenantId, String clientId, String client_secret) throws IOException {
        String sURL = "https://login.microsoftonline.com/" + tenantId + "/oauth2/v2.0/token";
        logger.finest("...oauth login url=" + sURL);
        HttpsURLConnection httpClient = (HttpsURLConnection)new URL(sURL).openConnection();
        httpClient.setRequestMethod("POST");
        httpClient.setRequestProperty("User-Agent", "Mozilla/5.0");
        httpClient.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
        String scopes = "https://outlook.office365.com/.default";
        String urlParameters = "client_id=" + clientId + "&scope=" + scopes + "&client_secret=" + client_secret + "&grant_type=client_credentials";
        httpClient.setDoOutput(true);
        try (DataOutputStream wr = new DataOutputStream(httpClient.getOutputStream());){
            wr.writeBytes(urlParameters);
            wr.flush();
        }
        int responseCode = httpClient.getResponseCode();
        if (responseCode >= 200 && responseCode <= 299) {
            byte[] response = IMAPImportHelper.readAllBytes(httpClient.getInputStream());
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(new String(response)));
            JsonObject jsonObject = jsonReader.readObject();
            String token = jsonObject.getString("access_token");
            logger.fine("....access token = " + token);
            return token;
        }
        logger.severe("Failed to receive a valid token!");
        return null;
    }
}

