/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Store;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.archive.importer.mail.IMAPAuthenticator;
import org.imixs.archive.importer.mail.IMAPImportHelper;
import org.imixs.archive.importer.mail.MailMessageService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.ModelService;
import org.imixs.workflow.engine.WorkflowService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.ModelException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;

@Stateless
public class IMAPImportService {
    public static final String OPTION_DEBUG = "debug";
    public static final String OPTION_ARCHIVE_FOLDER = "archive.folder";
    public static final String OPTION_SUBJECT_REGEX = "subject.regex";
    public static final String OPTION_IMAP_AUTHENTICATOR = "imap.authenticator";
    public static final String OPTION_DETACH_MODE = "detach.mode";
    public static final String OPTION_PRESERVE_ORIGIN = "preserve.origin";
    public static final String OPTION_GOTENBERG_SERVICE = "gotenberg.service";
    public static final String DETACH_MODE_PDF = "PDF";
    public static final String DETACH_MODE_ALL = "ALL";
    public static final String DETACH_MODE_NONE = "NONE";
    public static final String ARCHIVE_DEFAULT_NAME = "imixs-archive";
    public static final String DEFAULT_NO_SUBJECT = "no subject";
    private static Logger logger = Logger.getLogger(IMAPImportService.class.getName());
    @EJB
    WorkflowService workflowService;
    @EJB
    ModelService modelService;
    @EJB
    DocumentImportService documentImportService;
    @EJB
    MailMessageService mailMessageService;
    @Inject
    @Any
    protected Instance<IMAPAuthenticator> imapAuthenticators;

    public void onEvent(@Observes DocumentImportEvent event) {
        IMAPFolder inboxFolder = null;
        if (event.getResult() == 1) {
            logger.finest("...... import source already completed - no processing will be performed.");
            return;
        }
        if (!"IMAP".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
            logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skiped.");
            return;
        }
        String imapServer = event.getSource().getItemValueString("server");
        String importFolderName = event.getSource().getItemValueString("selector");
        Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
        Pattern subjectPattern = null;
        String subjectRegex = sourceOptions.getProperty(OPTION_SUBJECT_REGEX, "");
        boolean debug = Boolean.getBoolean(sourceOptions.getProperty(OPTION_DEBUG, "false"));
        if (subjectRegex != null && !subjectRegex.trim().isEmpty()) {
            try {
                subjectPattern = Pattern.compile(subjectRegex);
                this.documentImportService.logMessage("...subject.regex = " + subjectRegex, event);
            }
            catch (PatternSyntaxException e) {
                this.documentImportService.logMessage("Error - invalid subject regex: " + e.getMessage(), event);
                return;
            }
        }
        try {
            Store store = null;
            IMAPAuthenticator imapAuthenticator = null;
            String authenticatorClass = sourceOptions.getProperty(OPTION_IMAP_AUTHENTICATOR, "org.imixs.archive.importer.mail.IMAPBasicAuthenticator");
            for (IMAPAuthenticator _imapAuthenticator : this.imapAuthenticators) {
                if (!authenticatorClass.equals(_imapAuthenticator.getClass().getName())) continue;
                this.documentImportService.logMessage("...IMAPAuthenticator = " + authenticatorClass, event);
                imapAuthenticator = _imapAuthenticator;
                break;
            }
            store = imapAuthenticator.openMessageStore(event.getSource(), sourceOptions);
            this.documentImportService.logMessage("...connected to IMAP server: " + imapServer + " / " + importFolderName, event);
            inboxFolder = (IMAPFolder)store.getFolder("INBOX");
            IMAPFolder inportFolder = null;
            inportFolder = !importFolderName.isEmpty() ? (IMAPFolder)inboxFolder.getFolder(importFolderName) : inboxFolder;
            inportFolder.open(2);
            String detachOption = sourceOptions.getProperty(OPTION_DETACH_MODE, DETACH_MODE_PDF);
            this.documentImportService.logMessage("...detach.mode = " + detachOption, event);
            IMAPFolder archiveFolder = this.openImapArchive(store, inboxFolder, sourceOptions, event);
            Message[] messages = inportFolder.getMessages();
            this.documentImportService.logMessage("..." + messages.length + " new messages found", event);
            for (Message message : messages) {
                Object contentObject;
                Address[] fromAddress = null;
                String subject = null;
                try {
                    fromAddress = message.getFrom();
                    subject = message.getSubject();
                }
                catch (MessagingException me) {
                    this.documentImportService.logMessage("...Failed to read message from inbox: " + me.getMessage(), event);
                    continue;
                }
                if (subject == null || subject.trim().isEmpty()) {
                    subject = DEFAULT_NO_SUBJECT;
                }
                Date sent = message.getSentDate();
                logger.fine("......received mail from: " + fromAddress[0].toString());
                logger.fine("......subject = " + subject);
                if (subjectPattern != null) {
                    if (subject == null || DEFAULT_NO_SUBJECT.equals(subject)) continue;
                    Matcher subjectMatcher = subjectPattern.matcher(subject);
                    if (subjectMatcher == null) {
                        logger.finest("matcher is null!");
                        continue;
                    }
                    if (!subjectMatcher.find()) {
                        continue;
                    }
                } else {
                    logger.finest("...no regex pattern mail will be processed...");
                }
                ItemCollection workitem = this.createWorkitem(event.getSource());
                if (fromAddress[0] instanceof InternetAddress) {
                    InternetAddress internetAddr = (InternetAddress)fromAddress[0];
                    workitem.setItemValue("mail.from", (Object)internetAddr.getAddress());
                    workitem.setItemValue("mail.from.personal", (Object)internetAddr.getPersonal());
                } else {
                    workitem.setItemValue("mail.from", (Object)fromAddress[0].toString());
                }
                workitem.setItemValue("mail.subject", (Object)subject);
                workitem.setItemValue("mail.sent", (Object)sent);
                if (!DETACH_MODE_NONE.equals(detachOption) && (contentObject = message.getContent()) instanceof Multipart) {
                    Multipart multiPart = (Multipart)message.getContent();
                    for (int i = 0; i < multiPart.getCount(); ++i) {
                        MimeBodyPart mimeBodyPart;
                        BodyPart bodyPart = multiPart.getBodyPart(i);
                        if (!(bodyPart instanceof MimeBodyPart) || !"attachment".equalsIgnoreCase((mimeBodyPart = (MimeBodyPart)multiPart.getBodyPart(i)).getDisposition())) continue;
                        String fileName = mimeBodyPart.getFileName();
                        if (fileName == null) {
                            logger.warning("...skip detaching file, because of missing filename");
                            continue;
                        }
                        fileName = MimeUtility.decodeText((String)fileName);
                        if (DETACH_MODE_PDF.equals(detachOption) && !fileName.toLowerCase().endsWith(".pdf")) continue;
                        InputStream input = mimeBodyPart.getInputStream();
                        byte[] content = IMAPImportHelper.readAllBytes(input);
                        String contentType = mimeBodyPart.getContentType();
                        if (debug) {
                            logger.info("mimetype=" + contentType);
                        }
                        if (IMAPImportHelper.isMediaTypeOctet(contentType, fileName) && fileName.toLowerCase().endsWith(".pdf")) {
                            logger.info("...converting mimetype '" + contentType + "' to application/pdf");
                            contentType = "application/pdf";
                        }
                        if (contentType.contains(";")) {
                            contentType = contentType.substring(0, contentType.indexOf(";"));
                        }
                        FileData fileData = new FileData(fileName, content, contentType, null);
                        workitem.addFileData(fileData);
                    }
                }
                if (DETACH_MODE_ALL.equals(detachOption)) {
                    String gotenbergService = sourceOptions.getProperty(OPTION_GOTENBERG_SERVICE);
                    if (gotenbergService != null && !gotenbergService.isEmpty()) {
                        try {
                            logger.info("using gotenbergservice: " + gotenbergService);
                            this.mailMessageService.attachPDFMessage(message, workitem, gotenbergService);
                        }
                        catch (IOException eio) {
                            this.documentImportService.logMessage("... connectiong to gotenberg service '" + gotenbergService + "' failed: " + eio.getMessage() + " message will be added in HTML format!", event);
                            this.mailMessageService.attachHTMLMessage(message, workitem);
                        }
                    } else {
                        this.mailMessageService.attachHTMLMessage(message, workitem);
                    }
                    String preserveOrigin = sourceOptions.getProperty(OPTION_PRESERVE_ORIGIN, "true");
                    if (preserveOrigin != null && "true".equalsIgnoreCase(preserveOrigin)) {
                        this.mailMessageService.attachMessage(message, workitem);
                    }
                }
                if (!DETACH_MODE_ALL.equalsIgnoreCase(detachOption)) {
                    this.mailMessageService.attachMessage(message, workitem);
                }
                workitem = this.workflowService.processWorkItemByNewTransaction(workitem);
                Message[] messageList = new Message[]{message};
                inportFolder.moveMessages(messageList, (Folder)archiveFolder);
            }
            logger.finest("...completed");
        }
        catch (AccessDeniedException | ModelException | PluginException | ProcessingErrorException e) {
            this.documentImportService.logMessage("IMAP import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
        catch (MessagingException | IOException e) {
            this.documentImportService.logMessage("IMAP import failed: " + e.getMessage(), event);
            event.setResult(2);
            return;
        }
    }

    private IMAPFolder openImapArchive(Store store, IMAPFolder inbox, Properties sourceOptions, DocumentImportEvent event) throws MessagingException {
        String imapArchiveFolder = sourceOptions.getProperty(OPTION_ARCHIVE_FOLDER, ARCHIVE_DEFAULT_NAME);
        this.documentImportService.logMessage("...archive.folder = " + imapArchiveFolder, event);
        IMAPFolder archive = (IMAPFolder)inbox.getFolder(imapArchiveFolder);
        if (!archive.exists()) {
            logger.info("...creating folder '" + imapArchiveFolder + "'");
            boolean isCreated = archive.create(1);
            if (isCreated) {
                logger.info("...folder sucessfull created");
            } else {
                logger.info("...failed to create new archvie folder!");
            }
        }
        archive.open(2);
        return archive;
    }

    public ItemCollection createWorkitem(ItemCollection source) throws AccessDeniedException, ProcessingErrorException, PluginException, ModelException {
        ItemCollection workitem = new ItemCollection();
        workitem.model(source.getItemValueString("workflowmodel"));
        workitem.task(source.getItemValueInteger("task"));
        workitem.event(source.getItemValueInteger("event"));
        workitem.setWorkflowGroup(source.getItemValueString("workflowgroup"));
        workitem.setItemValue("document.import.type", (Object)source.getItemValue("type"));
        workitem.setItemValue("document.import.selector", (Object)source.getItemValue("selector"));
        workitem.setItemValue("document.import.options", (Object)source.getItemValue("options"));
        return workitem;
    }
}

