/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.ftp;

import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPSClient;
import org.imixs.archive.importer.DocumentImportEvent;
import org.imixs.archive.importer.DocumentImportService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.engine.DocumentService;
import org.imixs.workflow.engine.index.UpdateService;
import org.imixs.workflow.exceptions.AccessDeniedException;
import org.imixs.workflow.exceptions.PluginException;
import org.imixs.workflow.exceptions.ProcessingErrorException;
import org.imixs.workflow.exceptions.QueryException;

@Named
public class CSVImportService {
    public static final String DATA_ERROR = "DATA_ERROR";
    public static final String IMPORT_ERROR = "IMPORT_ERROR";
    private static Logger logger = Logger.getLogger(CSVImportService.class.getName());
    @Inject
    UpdateService indexUpdateService;
    @Inject
    DocumentService documentService;
    @Inject
    DocumentImportService documentImportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(@Observes DocumentImportEvent event) {
        block47: {
            FTPSClient ftpClient = null;
            if (event.getResult() == 1) {
                logger.finest("...... import source already completed - no processing will be performed.");
                return;
            }
            if (!"CSV".equalsIgnoreCase(event.getSource().getItemValueString("type"))) {
                logger.finest("...... type '" + event.getSource().getItemValueString("type") + "' skipped.");
                return;
            }
            try {
                String encoding;
                String ftpServer = event.getSource().getItemValueString("server");
                String ftpPort = event.getSource().getItemValueString("port");
                String ftpUser = event.getSource().getItemValueString("user");
                String ftpPassword = event.getSource().getItemValueString("password");
                Object csvSelector = event.getSource().getItemValueString("selector");
                Properties sourceOptions = this.documentImportService.getOptionsProperties(event.getSource());
                String type = sourceOptions.getProperty("type");
                if (type == null || type.isEmpty()) {
                    throw new PluginException(this.getClass().getName(), DATA_ERROR, "Missing property 'type' to import entities");
                }
                Object keyField = sourceOptions.getProperty("key");
                if (keyField == null || ((String)keyField).isEmpty()) {
                    throw new PluginException(this.getClass().getName(), DATA_ERROR, "Missing property 'key' to import entities");
                }
                if (!((String)keyField).startsWith("_")) {
                    keyField = "_" + (String)keyField;
                }
                if ((encoding = sourceOptions.getProperty("encoding")) == null || encoding.isEmpty()) {
                    encoding = "UTF-8";
                }
                if (!((String)csvSelector).startsWith("/") && !((String)csvSelector).startsWith("./")) {
                    csvSelector = "/" + (String)csvSelector;
                }
                if (!((String)csvSelector).toLowerCase().endsWith(".csv")) {
                    this.documentImportService.logMessage("...invalid selector - .csv file path expected - " + (String)csvSelector, event);
                }
                if (ftpServer.isEmpty()) {
                    logger.warning("...... no server specified!");
                    return;
                }
                if (ftpPort.isEmpty()) {
                    ftpPort = "21";
                }
                logger.finest("......read directories ...");
                this.documentImportService.logMessage("...csv import: " + (String)csvSelector, event);
                this.documentImportService.logMessage("...connecting to FTP server: " + ftpServer, event);
                ftpClient = new FTPSClient("TLS", false);
                ftpClient.setControlEncoding(encoding);
                ftpClient.connect(ftpServer, Integer.parseInt(ftpPort));
                if (!ftpClient.login(ftpUser, ftpPassword)) {
                    this.documentImportService.logMessage("FTP file transfer failed: login failed!", event);
                    event.setResult(2);
                    return;
                }
                ftpClient.enterLocalPassiveMode();
                logger.finest("...... FileType=2");
                ftpClient.setFileType(2);
                ftpClient.setControlEncoding(encoding);
                File file = new File((String)csvSelector);
                String csvFTPPath = file.getParent();
                String csvFilename = file.getName();
                boolean bWorkingDir = ftpClient.changeWorkingDirectory(csvFTPPath);
                if (bWorkingDir) {
                    this.documentImportService.logMessage("...working directory: " + ftpClient.printWorkingDirectory(), event);
                    logger.info("import file " + csvFilename + "...");
                    try (ByteArrayOutputStream is = new ByteArrayOutputStream();){
                        ftpClient.retrieveFile(csvFilename, (OutputStream)is);
                        byte[] rawData = is.toByteArray();
                        if (rawData != null && rawData.length > 0) {
                            logger.finest("......file '" + file.getName() + "' successful read - bytes size = " + rawData.length);
                            String lastChecksum = event.getSource().getItemValueString("csv.checksum");
                            FileData fileData = new FileData(file.getName(), rawData, null, null);
                            String newChecksum = fileData.generateMD5();
                            this.documentImportService.logMessage("...checksum=" + newChecksum, event);
                            if (lastChecksum.isEmpty() || !lastChecksum.equals(newChecksum)) {
                                ByteArrayInputStream inputStream = new ByteArrayInputStream(rawData);
                                String log = this.importData(inputStream, encoding, type, (String)keyField, event);
                                event.getSource().setItemValue("csv.checksum", (Object)newChecksum);
                                this.documentImportService.logMessage(log, event);
                            } else {
                                this.documentImportService.logMessage("...no changes '" + file.getName() + "'", event);
                            }
                        } else {
                            this.documentImportService.logMessage("...Warning - invalid file content '" + file.getName() + "' - file will be deleted!", event);
                        }
                        break block47;
                    }
                    catch (NoSuchAlgorithmException | AccessDeniedException | PluginException | ProcessingErrorException e) {
                        this.documentImportService.logMessage("...FTP import failed: " + e.getMessage(), event);
                        event.setResult(2);
                        try {
                            ftpClient.logout();
                            ftpClient.disconnect();
                        }
                        catch (IOException e2) {
                            this.documentImportService.logMessage("...FTP file transfer failed: " + e2.getMessage(), event);
                            event.setResult(2);
                            return;
                        }
                        return;
                    }
                }
                this.documentImportService.logMessage("...failed to change into working directory: " + csvFTPPath, event);
            }
            catch (IOException e) {
                logger.severe("FTP I/O Error: " + e.getMessage());
                int r = ftpClient.getReplyCode();
                logger.severe("FTP ReplyCode=" + r);
                this.documentImportService.logMessage("...FTP file transfer failed (replyCode=" + r + ") : " + e.getMessage(), event);
                event.setResult(2);
                return;
            }
            catch (PluginException e) {
                logger.severe("Data Error: " + e.getMessage());
                e.printStackTrace();
                this.documentImportService.logMessage("...FTP csv import error  : " + e.getMessage(), event);
                event.setResult(2);
                return;
            }
            finally {
                try {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    this.documentImportService.logMessage("...FTP file transfer failed: " + e.getMessage(), event);
                    event.setResult(2);
                    return;
                }
            }
        }
        this.indexUpdateService.updateIndex();
        event.setResult(1);
    }

    public String importData(InputStream inputStream, String encoding, String type, String keyField, DocumentImportEvent event) throws PluginException {
        logger.fine("...starting csv data import...");
        Object log = "";
        int line = 0;
        String dataLine = null;
        ArrayList<String> idCache = new ArrayList<String>();
        int workitemsTotal = 0;
        int workitemsImported = 0;
        int workitemsUpdated = 0;
        int workitemsDeleted = 0;
        int workitemsFailed = 0;
        int blockSize = 0;
        String csvFileName = event.getSource().getItemValueString("selector");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, encoding));
            String header = in.readLine();
            List<String> fields = this.parseFieldList(header);
            if (fields == null || fields.size() == 0) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "File Format not supported, 1st line must contain the item names.");
            }
            if (type == null || type.isEmpty()) {
                throw new PluginException(this.getClass().getName(), IMPORT_ERROR, "Missing type to import entities");
            }
            logger.info("...object type=" + type);
            logger.info("...key field=" + keyField);
            ++line;
            while ((dataLine = in.readLine()) != null) {
                ++blockSize;
                ++line;
                ++workitemsTotal;
                ItemCollection entity = this.readEntity(dataLine, fields, type);
                String keyItemValue = entity.getItemValueString(keyField);
                entity.replaceItemValue("name", (Object)keyItemValue);
                entity.setItemValue("document.import.type", (Object)event.getSource().getItemValue("type"));
                entity.setItemValue("document.import.selector", (Object)event.getSource().getItemValue("selector"));
                entity.setItemValue("document.import.options", (Object)event.getSource().getItemValue("options"));
                if (idCache.contains(keyItemValue)) {
                    logger.warning("...WARNING duplicate entry found: " + keyField + "=" + keyItemValue);
                    this.documentImportService.logMessage("...WARNING duplicate entry found: " + keyField + "=" + keyItemValue, event);
                } else {
                    idCache.add(keyItemValue);
                }
                ItemCollection oldEntity = this.findEntityByName(entity.getItemValueString("Name"), type);
                if (oldEntity == null) {
                    this.documentService.saveByNewTransaction(entity);
                    ++workitemsImported;
                } else if (!this.isEqualEntity(oldEntity, entity, fields)) {
                    logger.fine("update existing entity: " + oldEntity.getUniqueID());
                    oldEntity.replaceAllItems(entity.getAllItems());
                    this.documentService.saveByNewTransaction(oldEntity);
                    ++workitemsUpdated;
                }
                if (blockSize < 100) continue;
                blockSize = 0;
                logger.info("..." + csvFileName + ": " + workitemsTotal + " entries read (" + workitemsUpdated + " updates)");
                this.indexUpdateService.updateIndex();
            }
            logger.info("completed: " + workitemsTotal + " entries successful read");
        }
        catch (Exception e) {
            ++workitemsFailed;
            String sError = "import error at line " + line + ": " + e + " data=" + dataLine;
            logger.severe(sError);
            throw new PluginException(CSVImportService.class.getName(), DATA_ERROR, sError, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        workitemsDeleted = this.removeDeprecatedDocuments(idCache, type, csvFileName);
        log = (String)log + "..." + workitemsTotal + " entries read -> " + workitemsImported + " new entries - " + workitemsUpdated + " updates - " + workitemsDeleted + " deletions - " + workitemsFailed + " errors";
        logger.info((String)log);
        return log;
    }

    private int removeDeprecatedDocuments(List<String> idCache, String type, String csvFileName) {
        int deletions = 0;
        int firstResult = 0;
        int blockSize = 100;
        logger.info("..." + csvFileName + ": delete deprecated entries...");
        String sQuery = "SELECT document FROM Document AS document WHERE document.type='" + type + "' ORDER BY document.created ASC";
        while (true) {
            List entries = this.documentService.getDocumentsByQuery(sQuery, firstResult, blockSize);
            for (ItemCollection entity : entries) {
                String id = entity.getItemValueString("name");
                if (idCache.contains(id)) continue;
                this.documentService.remove(entity);
                ++deletions;
            }
            if (entries.size() != blockSize) break;
            logger.info("..." + csvFileName + ": " + (firstResult += blockSize) + " entries verified (" + deletions + " deletions)");
        }
        return deletions;
    }

    private ItemCollection readEntity(String data, List<String> fieldnames, String type) {
        ItemCollection result = new ItemCollection();
        result.replaceItemValue("type", (Object)type);
        int iCol = 0;
        String[] valuList = data.split(";(?=([^\"]*\"[^\"]*\")*[^\"]*$)", 99);
        for (String itemValue : valuList = this.normalizeValueList(valuList)) {
            if ((itemValue = itemValue.trim()) != null && !itemValue.isEmpty()) {
                result.replaceItemValue(fieldnames.get(iCol), (Object)itemValue);
            } else {
                result.replaceItemValue(fieldnames.get(iCol), (Object)"");
            }
            if (++iCol >= fieldnames.size()) break;
        }
        return result;
    }

    private String[] normalizeValueList(String[] data) {
        for (int i = 0; i < data.length; ++i) {
            String value = data[i];
            if (!value.startsWith("\"") || !value.endsWith("\"")) continue;
            data[i] = value = value.substring(1, value.length() - 1);
        }
        return data;
    }

    private List<String> parseFieldList(String data) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ";");
        while (st.hasMoreTokens()) {
            String field = st.nextToken().trim();
            if (!field.isEmpty()) {
                field = field.replace("\"", "");
                field = field.replace("'", "");
                field = field.replace(".", "");
                field = field.replace(' ', '_');
                field = field.replace('/', '_');
                field = field.replace('\\', '_');
                field = field.replace('.', '_');
                field = field.replace('>', '_');
                field = field.replace('<', '_');
                field = field.replace('&', '_');
                result.add("_" + field.trim());
                continue;
            }
            result.add(null);
        }
        return result;
    }

    private boolean isEqualEntity(ItemCollection oldEntity, ItemCollection entity, List<String> fields) {
        for (String itemName : fields) {
            if (entity.getItemValue(itemName).equals(oldEntity.getItemValue(itemName))) continue;
            return false;
        }
        return true;
    }

    public ItemCollection findEntityByName(String key, String type) {
        String searchTerm = "(type:\"" + type + "\" AND name:\"" + key + "\")";
        try {
            List col = this.documentService.find(searchTerm, 1, 0);
            if (col.size() > 0) {
                return (ItemCollection)col.iterator().next();
            }
        }
        catch (QueryException e) {
            logger.warning(e.getMessage());
        }
        return null;
    }
}

