/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.importer.mail;

import jakarta.ejb.LocalBean;
import jakarta.ejb.Stateless;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stateless
@LocalBean
public class MailConverterService {
    private static Logger logger = Logger.getLogger(MailConverterService.class.getName());
    private static final DateFormat DATE_FORMATTER = DateFormat.getDateTimeInstance(1, 1);
    private static final Pattern IMG_CID_REGEX = Pattern.compile("cid:(.*?)\"", 32);
    private static final String HTML_WRAPPER_TEMPLATE_HEADER = "<!DOCTYPE html><html><head><style>body{font-size: 0.5cm;}</style><meta charset=\"utf-8\"><title>title</title></head><body>";
    private static final String HTML_WRAPPER_TEMPLATE_FOOTER = "</body></html>";

    public String convertToHTML(Message message) throws IOException, MessagingException {
        logger.fine("Start converting MimeMessage...");
        String htmlResult = null;
        String rawText = null;
        try {
            Object contentObject = message.getContent();
            if (!(contentObject instanceof Multipart)) {
                logger.warning("mail is plain text");
                return contentObject.toString();
            }
            Multipart multiPart = (Multipart)message.getContent();
            int countBodyParts = multiPart.getCount();
            for (int i = 0; i < countBodyParts; ++i) {
                logger.fine("-------------------------------------------------------------");
                try {
                    BodyPart bodyPart = multiPart.getBodyPart(i);
                    String contentType = bodyPart.getContentType();
                    logger.fine("Mail Bodypart-" + i + " contenttype=" + contentType);
                    rawText = this.getText((Part)bodyPart);
                    if (rawText == null) continue;
                    logger.fine("RawText=" + rawText);
                    if (!this.isHtmlContent(rawText)) continue;
                    htmlResult = this.convertEmbeddedHTMLImages(rawText, bodyPart, message);
                    break;
                }
                catch (Exception e) {
                    logger.warning("unable to convert message part into html : " + e.getMessage());
                }
            }
            if (htmlResult == null && (htmlResult = this.buildHtmlfromPlainText(rawText)) == null) {
                return null;
            }
            try {
                htmlResult = this.insertEmailHeader((MimeMessage)message, htmlResult);
            }
            catch (Exception e) {
                logger.warning("unable to insert html header into message object: " + e.getMessage());
            }
        }
        catch (Exception e) {
            logger.warning("unable to convert message object into html : " + e.getMessage());
            return null;
        }
        return htmlResult;
    }

    private String convertEmbeddedHTMLImages(String html, BodyPart htmlBodyPart, Message message) throws IOException, MessagingException {
        Matcher m = IMG_CID_REGEX.matcher(html);
        while (m.find()) {
            String toBeReplaced = m.group(0);
            if (toBeReplaced.endsWith("\"")) {
                toBeReplaced = toBeReplaced.substring(0, toBeReplaced.length() - 1);
            }
            String contentID = "<" + m.group(1) + ">";
            logger.fine("...contentID=" + contentID);
            logger.fine("...toBeReplaced=" + toBeReplaced);
            MimeBodyPart mbp = this.findMimeBodyPartByID(message, contentID);
            if (mbp == null) continue;
            ByteArrayOutputStream aos = new ByteArrayOutputStream();
            mbp.writeTo((OutputStream)aos);
            String imgContent = aos.toString();
            String[] teile = imgContent.split("\\r\\n");
            Object newContent = "";
            boolean start = false;
            for (String base64part : teile) {
                if (start) {
                    newContent = (String)newContent + base64part;
                    continue;
                }
                if (!base64part.isEmpty()) continue;
                start = true;
            }
            String newDataSrc = "data:" + mbp.getContentType() + ";base64," + (String)newContent;
            html = html.replace(toBeReplaced, newDataSrc);
            logger.fine("new data src=" + newDataSrc);
        }
        return html;
    }

    private String buildHtmlfromPlainText(String rawText) {
        Object htmlResult = null;
        if (rawText == null) {
            return null;
        }
        rawText = rawText.replace("\n", "<br/>");
        rawText = rawText.replace("\r", "");
        htmlResult = HTML_WRAPPER_TEMPLATE_HEADER;
        htmlResult = (String)htmlResult + "<div style=\"white-space: pre-wrap\">";
        htmlResult = (String)htmlResult + rawText + "</div>";
        htmlResult = (String)htmlResult + HTML_WRAPPER_TEMPLATE_FOOTER;
        return htmlResult;
    }

    private boolean isHtmlContent(String content) {
        String _tmp_content = content.trim();
        if (_tmp_content.startsWith("<html")) {
            return true;
        }
        return _tmp_content.startsWith("<!DOCTYPE");
    }

    private String getText(Part p) throws MessagingException, IOException {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            return s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (bp.isMimeType("text/plain")) {
                    if (text != null) continue;
                    text = this.getText((Part)bp);
                    continue;
                }
                if (bp.isMimeType("text/html")) {
                    String s = this.getText((Part)bp);
                    if (s == null) continue;
                    return s;
                }
                return this.getText((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getText((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private MimeBodyPart findMimeBodyPartByID(Message message, String id) throws MessagingException, IOException {
        Multipart multiPart = (Multipart)message.getContent();
        int countBodyParts = multiPart.getCount();
        for (int i = 0; i < countBodyParts; ++i) {
            Multipart mp;
            MimeBodyPart mbp;
            BodyPart bodyPart = multiPart.getBodyPart(i);
            if (bodyPart.isMimeType("multipart/*") && (mbp = this.findMimeBodyPartByID(mp = (Multipart)bodyPart.getContent(), id)) != null) {
                return mbp;
            }
            if (!bodyPart.isMimeType("image/*") || !this.isImagePart((Part)bodyPart, id)) continue;
            return (MimeBodyPart)bodyPart;
        }
        return null;
    }

    private MimeBodyPart findMimeBodyPartByID(Multipart mp, String id) throws MessagingException, IOException {
        for (int i = 0; i < mp.getCount(); ++i) {
            MimeBodyPart mimeBodyPart;
            BodyPart bp = mp.getBodyPart(i);
            if (this.isImagePart((Part)bp, id)) {
                return (MimeBodyPart)bp;
            }
            if (bp.isMimeType("multipart/*") && !(bp instanceof Multipart) && bp.getContent() instanceof Multipart && (mimeBodyPart = this.findMimeBodyPartByID((Multipart)bp.getContent(), id)) != null) {
                return mimeBodyPart;
            }
            if (!(bp instanceof Multipart) || (mimeBodyPart = this.findMimeBodyPartByID((Multipart)bp, id)) == null) continue;
            return mimeBodyPart;
        }
        return null;
    }

    private boolean isImagePart(Part bp, String id) throws MessagingException {
        if (bp instanceof MimeBodyPart) {
            MimeBodyPart mbp = (MimeBodyPart)bp;
            String currentID = mbp.getContentID();
            String contentType = mbp.getContentType();
            logger.fine("...contentID=" + currentID);
            logger.fine("...contentType=" + contentType);
            if (mbp.getContentType().startsWith("image/") && currentID.equals(id)) {
                return true;
            }
        }
        return false;
    }

    private String insertEmailHeader(MimeMessage message, String html) throws MessagingException {
        String subject = message.getSubject();
        String sentDateStr = null;
        try {
            Date sentDate = message.getSentDate();
            sentDateStr = DATE_FORMATTER.format(sentDate);
        }
        catch (Exception e) {
            sentDateStr = message.getHeader("date", null);
        }
        String from = message.getHeader("From", null);
        if (from == null) {
            from = message.getHeader("Sender", null);
        }
        try {
            from = MimeUtility.decodeText((String)MimeUtility.unfold((String)from));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CharSequence[] recipientsTo = new String[]{};
        String recipientsRaw = message.getHeader("To", null);
        if (recipientsRaw != null && !recipientsRaw.isEmpty()) {
            try {
                recipientsRaw = MimeUtility.unfold((String)recipientsRaw);
                recipientsTo = recipientsRaw.split(",");
                for (int i = 0; i < recipientsTo.length; ++i) {
                    recipientsTo[i] = MimeUtility.decodeText((String)recipientsTo[i]);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        CharSequence[] recipientsCC = new String[]{};
        recipientsRaw = message.getHeader("CC", null);
        if (recipientsRaw != null && !recipientsRaw.isEmpty()) {
            try {
                recipientsRaw = MimeUtility.unfold((String)recipientsRaw);
                recipientsCC = recipientsRaw.split(",");
                for (int i = 0; i < recipientsCC.length; ++i) {
                    recipientsCC[i] = MimeUtility.decodeText((String)recipientsCC[i]);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        CharSequence[] recipientsBCC = new String[]{};
        recipientsRaw = message.getHeader("BCC", null);
        if (recipientsRaw != null && !recipientsRaw.isEmpty()) {
            try {
                recipientsRaw = MimeUtility.unfold((String)recipientsRaw);
                recipientsBCC = recipientsRaw.split(",");
                for (int i = 0; i < recipientsBCC.length; ++i) {
                    recipientsBCC[i] = MimeUtility.decodeText((String)recipientsBCC[i]);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        String mailHeader = "<table style=\"border:none;\">\n  <tr><td><strong>Date: </strong></td><td>" + sentDateStr + "</td></tr>\n  <tr><td><strong>From: </strong></td><td>" + from + "</td></tr>\n  <tr><td><strong>Subject: </strong></td><td>" + subject + "</td></tr>\n  <tr><td><strong>To: </strong></td><td>" + String.join((CharSequence)",", recipientsTo) + "</td></tr>\n";
        if (recipientsCC.length > 0) {
            mailHeader = mailHeader + "  <tr><td><strong>CC: </strong></td><td>" + String.join((CharSequence)",", recipientsCC) + "</td></tr>\n";
        }
        if (recipientsBCC.length > 0) {
            mailHeader = mailHeader + "  <tr><td><strong>BCC: </strong></td><td>" + String.join((CharSequence)",", recipientsBCC) + "</td></tr>\n";
        }
        mailHeader = mailHeader + "</table><hr />";
        int iPos = html.toLowerCase().indexOf("<body");
        iPos = html.indexOf(">", iPos + 4) + 1;
        Object result = html.substring(0, iPos);
        result = (String)result + mailHeader;
        result = (String)result + html.substring(iPos);
        return result;
    }
}

