/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;

@Singleton
public class MessageService {
    private static final int MAX_COUNT = 100;
    private List<String> messages;
    private static Logger logger = Logger.getLogger(MessageService.class.getName());

    @PostConstruct
    void init() {
        this.messages = new ArrayList();
    }

    public List<String> getMessages() {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public void logMessage(String message) {
        logger.info(message);
        SimpleDateFormat dateFormatDE = new SimpleDateFormat("dd.MM.yy hh:mm:ss");
        message = dateFormatDE.format(new Date()) + " : " + message;
        this.messages.add(message);
        while (this.messages.size() > 100) {
            this.messages.remove(0);
        }
    }

    public static String userFriendlyBytes(long bytes) {
        int unit;
        boolean si = true;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

