/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.scheduler;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.ScheduleExpression;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.scheduler.RemoteAPIService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class SyncService {
    public static final String TIMER_ID_SYNCSERVICE = "IMIXS_ARCHIVE_SYNC_TIMER";
    public static final String ITEM_SYNCPOINT = "$sync_point";
    public static final String ITEM_SYNCCOUNT = "$sync_count";
    public static final String ITEM_SYNCSIZE = "$sync_size";
    public static final String DEFAULT_SCHEDULER_DEFINITION = "hour=*";
    private static final int MAX_COUNT = 100;
    @Resource
    TimerService timerService;
    @EJB
    DataService dataService;
    @EJB
    ClusterService clusterService;
    @EJB
    MessageService messageService;
    private static Logger logger = Logger.getLogger(SyncService.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startScheduler() throws ArchiveException {
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...init imixsarchive keyspace ...");
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            if (session != null) {
                logger.info("...starting schedulers...");
                this.start();
                boolean bl = true;
                return bl;
            }
            logger.warning("...Failed to initalize imixs-archive keyspace!");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    public Date getNextTimeout() {
        try {
            Timer timer = this.findTimer();
            if (timer != null) {
                return timer.getNextTimeout();
            }
        }
        catch (Exception e) {
            logger.warning("unable to updateTimerDetails: " + e.getMessage());
        }
        return null;
    }

    private void start() throws ArchiveException {
        Timer timer = null;
        timer = this.findTimer();
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                this.messageService.logMessage("Failed to stop existing timer - " + e.getMessage());
                throw new ArchiveException(SyncService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        try {
            logger.info("...starting scheduler sync-service ...");
            timer = this.createTimerOnCalendar();
            if (timer != null) {
                this.messageService.logMessage("Timer started.");
            }
        }
        catch (ParseException e) {
            throw new ArchiveException(SyncService.class.getName(), "INVALID_WORKITEM", " failed to start timer: " + e.getMessage());
        }
    }

    private void stop(Timer timer) throws ArchiveException {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Exception e) {
                this.messageService.logMessage("Failed to stop timer - " + e.getMessage());
            }
            this.messageService.logMessage("Timer stopped. ");
        }
    }

    private Timer findTimer() {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!TIMER_ID_SYNCSERVICE.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    Timer createTimerOnCalendar() throws ParseException, ArchiveException {
        String[] calendarConfiguation;
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)((Object)TIMER_ID_SYNCSERVICE));
        ScheduleExpression scheduerExpression = new ScheduleExpression();
        String sDefinition = ClusterService.getEnv((String)"ARCHIVE_SCHEDULER_DEFINITION", (String)DEFAULT_SCHEDULER_DEFINITION);
        for (String confgEntry : calendarConfiguation = sDefinition.split("(\\r?\\n)|(;)|(,)")) {
            Date convertedDate;
            SimpleDateFormat dateFormat;
            if (confgEntry.startsWith("second=")) {
                scheduerExpression.second(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("minute=")) {
                scheduerExpression.minute(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("hour=")) {
                scheduerExpression.hour(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfWeek=")) {
                scheduerExpression.dayOfWeek(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("dayOfMonth=")) {
                scheduerExpression.dayOfMonth(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("month=")) {
                scheduerExpression.month(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("year=")) {
                scheduerExpression.year(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("timezone=")) {
                scheduerExpression.timezone(confgEntry.substring(confgEntry.indexOf(61) + 1));
            }
            if (confgEntry.startsWith("start=")) {
                dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
                scheduerExpression.start(convertedDate);
            }
            if (!confgEntry.startsWith("end=")) continue;
            dateFormat = new SimpleDateFormat("yyyy/MM/dd");
            convertedDate = dateFormat.parse(confgEntry.substring(confgEntry.indexOf(61) + 1));
            scheduerExpression.end(convertedDate);
        }
        Timer timer = this.timerService.createCalendarTimer(scheduerExpression, timerConfig);
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    void onTimeout(Timer timer) throws Exception {
        long syncPoint = 0L;
        int syncupdate = 0;
        int syncread = 0;
        long totalCount = 0L;
        long totalSize = 0L;
        Session session = null;
        Cluster cluster = null;
        ItemCollection metaData = null;
        long lProfiler = System.currentTimeMillis();
        try {
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            metaData = this.dataService.loadMetadata(session);
            syncPoint = metaData.getItemValueLong(ITEM_SYNCPOINT);
            totalCount = metaData.getItemValueLong(ITEM_SYNCCOUNT);
            totalSize = metaData.getItemValueLong(ITEM_SYNCSIZE);
            logger.info("...start syncronizing at syncpoint " + new Date(syncPoint) + "...");
            Date now = new Date();
            if (syncPoint > now.getTime()) {
                logger.warning("...current syncpoint (" + syncPoint + ") is in the future! Adjust Syncpoint to now (" + now.getTime() + ")....");
                syncPoint = now.getTime();
            }
            while (syncread < 100) {
                XMLDataCollection xmlDataCollection = RemoteAPIService.readSyncData((long)syncPoint);
                if (xmlDataCollection != null) {
                    List<XMLDocument> snapshotList = Arrays.asList(xmlDataCollection.getDocument());
                    for (XMLDocument xmlDocument : snapshotList) {
                        ItemCollection snapshot = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
                        Date syncpointdate = snapshot.getItemValueDate("$modified");
                        syncPoint = syncpointdate.getTime();
                        logger.fine("......data found - new syncpoint=" + syncPoint);
                        if (!this.dataService.existSnapshot(snapshot.getUniqueID(), session)) {
                            this.dataService.saveSnapshot(snapshot, session);
                            ++syncupdate;
                            ++totalCount;
                            totalSize += DataService.calculateSize((XMLDocument)xmlDocument);
                        } else {
                            logger.fine("...snapshot '" + snapshot.getUniqueID() + "' already exits....");
                        }
                        ++syncread;
                        metaData.setItemValue(ITEM_SYNCPOINT, (Object)syncPoint);
                        metaData.setItemValue(ITEM_SYNCCOUNT, (Object)totalCount);
                        metaData.setItemValue(ITEM_SYNCSIZE, (Object)totalSize);
                        this.dataService.saveMetadata(metaData, session);
                    }
                    continue;
                }
                logger.finest("......no more data found for syncpoint: " + syncPoint);
                break;
            }
            if (syncread > 0) {
                this.messageService.logMessage("... " + syncread + " snapshots verified (" + syncupdate + " updates) in: " + (System.currentTimeMillis() - lProfiler) + " ms, next syncpoint " + new Date(syncPoint));
            } else {
                logger.info("...no data found at syncpoint " + new Date(syncPoint) + "...");
            }
        }
        catch (RuntimeException | ArchiveException e) {
            if (logger.isLoggable(Level.FINEST)) {
                e.printStackTrace();
            }
            this.messageService.logMessage("Scheduler failed: " + e.getMessage());
            this.stop(timer);
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }
}

