/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.scheduler.RemoteAPIService;
import org.imixs.archive.service.scheduler.SyncService;
import org.imixs.workflow.ItemCollection;

@Named
@SessionScoped
public class InspectController
implements Serializable {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(InspectController.class.getName());
    Cluster cluster = null;
    Session session = null;
    String uniqueid = null;
    List<String> snapshotIDs = null;
    String currentSnapshotID = null;
    @EJB
    ClusterService clusterService;
    @EJB
    DataService dataService;
    @EJB
    SyncService syncService;
    @EJB
    MessageService messageService;

    @PostConstruct
    void init() {
    }

    public String getUniqueid() {
        return this.uniqueid;
    }

    public void setUniqueid(String uniqueid) {
        this.uniqueid = uniqueid;
    }

    public List<String> getSnapshotIDs() {
        if (this.snapshotIDs == null) {
            this.snapshotIDs = new ArrayList();
        }
        return this.snapshotIDs;
    }

    public void setSnapshotIDs(List<String> snapshotIDs) {
        this.snapshotIDs = snapshotIDs;
    }

    public String getCurrentSnapshotID() {
        return this.currentSnapshotID;
    }

    public void setCurrentSnapshotID(String currentSnapshotID) {
        this.currentSnapshotID = currentSnapshotID;
    }

    public String getTime(String id) {
        String sTime = id.substring(id.lastIndexOf(45) + 1);
        long time = Long.parseLong(sTime);
        Date date = new Date(time);
        return date.toString();
    }

    public void loadSnapshotIDs() {
        try {
            this.cluster = this.clusterService.getCluster();
            this.session = this.clusterService.getArchiveSession(this.cluster);
            logger.info("......load snsaphosts for " + this.uniqueid + "...");
            this.snapshotIDs = this.dataService.loadSnapshotsByUnqiueID(this.uniqueid, this.session);
            Collections.sort(this.snapshotIDs, Collections.reverseOrder());
            this.setCurrentSnapshotID(RemoteAPIService.readSnapshotIDByUniqueID((String)this.uniqueid));
        }
        catch (ArchiveException e) {
            logger.severe("failed to load snapshot ids: " + e.getMessage());
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
    }

    public void restoreSnapshot(String id) {
        try {
            this.cluster = this.clusterService.getCluster();
            this.session = this.clusterService.getArchiveSession(this.cluster);
            logger.info("......load snsaphosts for " + this.uniqueid + "...");
            ItemCollection snapshot = this.dataService.loadSnapshot(id, this.session);
            RemoteAPIService.restoreSnapshot((ItemCollection)snapshot);
            this.snapshotIDs = this.dataService.loadSnapshotsByUnqiueID(this.uniqueid, this.session);
            Collections.sort(this.snapshotIDs, Collections.reverseOrder());
            this.setCurrentSnapshotID(RemoteAPIService.readSnapshotIDByUniqueID((String)this.uniqueid));
        }
        catch (ArchiveException e) {
            logger.severe("failed to load snapshot ids: " + e.getMessage());
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
    }
}

