/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.rest;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/archive")
@Produces(value={"application/json", "text/html", "application/xml", "text/xml"})
@Stateless
public class ArchiveRestService {
    @EJB
    ClusterService clusterService;
    @EJB
    DataService dataService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/snapshot/{snapshotid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public XMLDocument getSnapshot(@PathParam(value="snapshotid") String id) {
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...read snapshot...");
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            ItemCollection snapshot = this.dataService.loadSnapshot(id, session);
            XMLDocument xMLDocument = XMLDocumentAdapter.getDocument((ItemCollection)snapshot);
            return xMLDocument;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "text/xml"})
    @Path(value="/snapshot/xml/{snapshotid : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public XMLDocument getSnapshotXML(@PathParam(value="snapshotid") String id) {
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...read snapshot...");
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            ItemCollection snapshot = this.dataService.loadSnapshot(id, session);
            XMLDocument xMLDocument = XMLDocumentAdapter.getDocument((ItemCollection)snapshot);
            return xMLDocument;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/metadata")
    public XMLDocument getMetadata() {
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...read snapshot...");
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            ItemCollection snapshot = this.dataService.loadMetadata(session);
            XMLDocument xMLDocument = XMLDocumentAdapter.getDocument((ItemCollection)snapshot);
            return xMLDocument;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "text/xml"})
    @Path(value="/metadata/xml")
    public XMLDocument getMetadataXML() {
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...read snapshot...");
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            ItemCollection snapshot = this.dataService.loadMetadata(session);
            XMLDocument xMLDocument = XMLDocumentAdapter.getDocument((ItemCollection)snapshot);
            return xMLDocument;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    static {
        logger = Logger.getLogger(ArchiveRestService.class.getName());
    }
}

