/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.rest;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.ItemCollection;

@Path(value="/metadata")
@Produces(value={"application/json", "text/html", "text/xml"})
@Stateless
public class MetatdataRestService {
    @EJB
    ClusterService clusterService;
    @EJB
    DataService dataService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/")
    public String getSyncpoint() {
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...read metadata...");
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            ItemCollection metadata = this.dataService.loadMetadata(session);
            String result = "syncpoint=" + metadata.getItemValueString("$sync_point");
            String string = result = result + "\ncount=" + metadata.getItemValueString("$sync_count");
            return string;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            String string = "NO DATA";
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    static {
        logger = Logger.getLogger(MetatdataRestService.class.getName());
    }
}

