/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.scheduler;

import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.ws.rs.client.ClientRequestFilter;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
public class RemoteAPIService {
    public static final String SNAPSHOT_RESOURCE = "snapshot/";
    public static final String DOCUMENTS_RESOURCE = "documents/";
    public static final String SNAPSHOT_SYNCPOINT_RESOURCE = "snapshot/syncpoint/";
    private static Logger logger = Logger.getLogger(RemoteAPIService.class.getName());

    public static XMLDataCollection readSyncData(long syncPoint) throws ArchiveException {
        XMLDataCollection result = null;
        DocumentClient documentClient = RemoteAPIService.initWorkflowClient();
        String url = "snapshot/syncpoint/" + syncPoint;
        logger.finest("...... read data: " + url + "....");
        try {
            result = documentClient.getCustomResourceXML(url);
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to readSyncData : " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
        if (result != null && result.getDocument().length > 0) {
            return result;
        }
        return null;
    }

    public static String readSnapshotIDByUniqueID(String uniqueid) throws ArchiveException {
        String result = null;
        DocumentClient documentClient = RemoteAPIService.initWorkflowClient();
        String url = "documents/" + uniqueid + "?items=$snapshotid";
        logger.finest("...... read snapshotid: " + url + "....");
        try {
            XMLDataCollection xmlDocument = documentClient.getCustomResourceXML(url);
            if (xmlDocument != null && xmlDocument.getDocument().length > 0) {
                ItemCollection document = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument.getDocument()[0]);
                result = document.getItemValueString("$snapshotid");
            }
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to readSyncData : " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
        return result;
    }

    public static void restoreSnapshot(ItemCollection snapshot) throws ArchiveException {
        DocumentClient documentClient = RemoteAPIService.initWorkflowClient();
        String url = "snapshot/";
        logger.finest("...... post data: " + url + "....");
        try {
            documentClient.postXMLDocument(url, XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to restoreSnapshot: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
    }

    static DocumentClient initWorkflowClient() {
        String url = ClusterService.getEnv((String)"WORKFLOW_SERVICE_ENDPOINT", null);
        String autMethod = ClusterService.getEnv((String)"WORKFLOW_SERVICE_AUTHMETHOD", null);
        String user = ClusterService.getEnv((String)"WORKFLOW_SERVICE_USER", null);
        String password = ClusterService.getEnv((String)"WORKFLOW_SERVICE_PASSWORD", null);
        logger.finest("...... WORKFLOW_SERVICE_ENDPOINT = " + url);
        DocumentClient documentClient = new DocumentClient(url);
        if ("Form".equalsIgnoreCase(autMethod)) {
            FormAuthenticator formAuth = new FormAuthenticator(url, user, password);
            documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
        } else {
            BasicAuthenticator basicAuth = new BasicAuthenticator(user, password);
            documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
        }
        return documentClient;
    }
}

