/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.scheduler.SyncService;
import org.imixs.workflow.ItemCollection;

@Named
@RequestScoped
public class ClusterDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ClusterDataController.class.getName());
    Cluster cluster = null;
    Session session = null;
    String syncSizeUnit = null;
    ItemCollection metaData = null;
    @EJB
    ClusterService clusterService;
    @EJB
    DataService dataService;
    @EJB
    SyncService syncService;
    @EJB
    MessageService messageService;

    @PostConstruct
    void init() throws ArchiveException {
        logger.info("...initial session....");
        this.cluster = this.clusterService.getCluster();
        this.session = this.clusterService.getArchiveSession(this.cluster);
        this.metaData = this.dataService.loadMetadata(this.session);
    }

    @PreDestroy
    void close() {
        logger.info("...closing session....");
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public Date getSyncPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("$sync_point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public long getSyncCount() {
        return this.metaData.getItemValueLong("$sync_count");
    }

    public String getSyncSize() {
        long l = this.metaData.getItemValueLong("$sync_size");
        String result = MessageService.userFriendlyBytes((long)l);
        String[] parts = result.split(" ");
        this.syncSizeUnit = parts[1];
        return parts[0];
    }

    public String getSyncSizeUnit() {
        return this.syncSizeUnit;
    }

    public String getContactPoints() {
        return ClusterService.getEnv((String)"ARCHIVE_CLUSTER_CONTACTPOINTS", null);
    }

    public String getKeySpace() {
        return ClusterService.getEnv((String)"ARCHIVE_CLUSTER_KEYSPACE", null);
    }

    public String getScheduler() {
        return ClusterService.getEnv((String)"ARCHIVE_SCHEDULER_DEFINITION", (String)"hour=*");
    }

    public String getReplicationFactor() {
        return ClusterService.getEnv((String)"ARCHIVE_CLUSTER_REPLICATION_FACTOR", (String)"1");
    }

    public String getReplicationClass() {
        return ClusterService.getEnv((String)"ARCHIVE_CLUSTER_REPLICATION_CLASS", (String)"SimpleStrategy");
    }

    public String getServiceEndpoint() {
        return ClusterService.getEnv((String)"WORKFLOW_SERVICE_ENDPOINT", null);
    }

    public Date getNextTimeout() {
        return this.syncService.getNextTimeout();
    }

    public List<String> getMessages() {
        List messageLog = this.messageService.getMessages();
        ArrayList<String> result = new ArrayList<String>();
        for (String message : messageLog) {
            result.add(message);
        }
        Collections.reverse(result);
        return result;
    }
}

