/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.enterprise.context.RequestScoped;
import javax.inject.Named;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.ItemCollection;

@Named
@RequestScoped
public class ResyncController
implements Serializable {
    public static final String ISO_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ResyncController.class.getName());
    Cluster cluster = null;
    Session session = null;
    ItemCollection metaData = null;
    String newSyncPoint = null;
    @EJB
    ClusterService clusterService;
    @EJB
    DataService dataService;
    @EJB
    MessageService messageService;

    @PostConstruct
    void init() throws ArchiveException {
        logger.info("...initial session....");
        this.cluster = this.clusterService.getCluster();
        this.session = this.clusterService.getArchiveSession(this.cluster);
        this.metaData = this.dataService.loadMetadata(this.session);
    }

    public String getNewSyncPoint() {
        if (this.newSyncPoint == null) {
            SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
            this.newSyncPoint = dt.format(this.getSyncPoint());
        }
        return this.newSyncPoint;
    }

    public void setNewSyncPoint(String newSyncPoint) {
        this.newSyncPoint = newSyncPoint;
    }

    public Date getSyncPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("$sync_point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public void updateSyncPoint() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat(ISO_DATETIME_FORMAT);
            Date syncDate = dt.parse(this.newSyncPoint);
            logger.info("......updateing syncpoint=" + this.newSyncPoint);
            this.metaData.setItemValue("$sync_point", (Object)syncDate.getTime());
            this.dataService.saveMetadata(this.metaData, this.session);
        }
        catch (ParseException | ArchiveException e) {
            logger.severe("failed to set new syncpoint: " + e.getMessage());
        }
    }
}

