/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import org.imixs.archive.service.ArchiveException;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
public class ClusterService {
    public static final String KEYSPACE_REGEX = "^[a-z_]*[^-]$";
    public static final String ENV_ARCHIVE_CLUSTER_CONTACTPOINTS = "ARCHIVE_CLUSTER_CONTACTPOINTS";
    public static final String ENV_ARCHIVE_CLUSTER_KEYSPACE = "ARCHIVE_CLUSTER_KEYSPACE";
    public static final String ENV_ARCHIVE_SCHEDULER_DEFINITION = "ARCHIVE_SCHEDULER_DEFINITION";
    public static final String ENV_ARCHIVE_CLUSTER_REPLICATION_FACTOR = "ARCHIVE_CLUSTER_REPLICATION_FACTOR";
    public static final String ENV_ARCHIVE_CLUSTER_REPLICATION_CLASS = "ARCHIVE_CLUSTER_REPLICATION_CLASS";
    public static final String ENV_WORKFLOW_SERVICE_ENDPOINT = "WORKFLOW_SERVICE_ENDPOINT";
    public static final String ENV_WORKFLOW_SERVICE_USER = "WORKFLOW_SERVICE_USER";
    public static final String ENV_WORKFLOW_SERVICE_PASSWORD = "WORKFLOW_SERVICE_PASSWORD";
    public static final String ENV_WORKFLOW_SERVICE_AUTHMETHOD = "WORKFLOW_SERVICE_AUTHMETHOD";
    public static final String TABLE_SCHEMA_SNAPSHOTS = "CREATE TABLE IF NOT EXISTS snapshots (snapshot text, data blob, PRIMARY KEY (snapshot))";
    public static final String TABLE_SCHEMA_SNAPSHOTS_BY_UNIQUEID = "CREATE TABLE IF NOT EXISTS snapshots_by_uniqueid (uniqueid text,snapshot text, PRIMARY KEY(uniqueid, snapshot));";
    public static final String TABLE_SCHEMA_SNAPSHOTS_BY_MODIFIED = "CREATE TABLE IF NOT EXISTS snapshots_by_modified (modified date,snapshot text,PRIMARY KEY(modified, snapshot));";
    public static final String TABLE_SCHEMA_DOCUMENTS = "CREATE TABLE IF NOT EXISTS documents (md5 text, sort_id int, data_id text, PRIMARY KEY (md5,sort_id))";
    public static final String TABLE_SCHEMA_SNAPSHOTS_BY_DOCUMENT = "CREATE TABLE IF NOT EXISTS snapshots_by_document (md5 text,snapshot text, PRIMARY KEY(md5, snapshot));";
    public static final String TABLE_SCHEMA_DOCUMENTS_DATA = "CREATE TABLE IF NOT EXISTS documents_data (data_id text, data blob, PRIMARY KEY (data_id))";
    private static Logger logger = Logger.getLogger(ClusterService.class.getName());

    public Session getArchiveSession(Cluster cluster) throws ArchiveException {
        String keySpace = ClusterService.getEnv((String)"ARCHIVE_CLUSTER_KEYSPACE", null);
        if (!this.isValidKeyspaceName(keySpace)) {
            throw new ArchiveException("INVALID_KEYSPACE", "keyspace '" + keySpace + "' name invalid.");
        }
        logger.finest("......conecting keyspace '" + keySpace + "'...");
        Session session = null;
        try {
            session = cluster.connect(keySpace);
        }
        catch (InvalidQueryException e) {
            logger.warning("......conecting keyspace '" + keySpace + "' failed: " + e.getMessage());
            session = this.createKeySpace(keySpace);
        }
        if (session != null) {
            logger.finest("......keyspace conection status = OK");
        }
        return session;
    }

    public Cluster getCluster() throws ArchiveException {
        String contactPoint = ClusterService.getEnv((String)"ARCHIVE_CLUSTER_CONTACTPOINTS", null);
        if (contactPoint == null || contactPoint.isEmpty()) {
            throw new ArchiveException("MISSING_CONTACTPOINT", "missing cluster contact points - verify configuration!");
        }
        logger.finest("......cluster conecting...");
        Cluster cluster = Cluster.builder().addContactPoint(contactPoint).build();
        cluster.init();
        logger.finest("......cluster conection status = OK");
        return cluster;
    }

    public boolean isValidKeyspaceName(String keySpace) {
        if (keySpace == null || keySpace.isEmpty()) {
            return false;
        }
        return keySpace.matches("^[a-z_]*[^-]$");
    }

    public static String getEnv(String env, String defaultValue) {
        String result = System.getenv(env);
        if (result == null || result.isEmpty()) {
            result = defaultValue;
        }
        return result;
    }

    protected Session createKeySpace(String keySpace) throws ArchiveException {
        logger.info("......creating new keyspace '" + keySpace + "'...");
        Cluster cluster = this.getCluster();
        Session session = cluster.connect();
        String repFactor = ClusterService.getEnv((String)"ARCHIVE_CLUSTER_REPLICATION_FACTOR", (String)"1");
        String repClass = ClusterService.getEnv((String)"ARCHIVE_CLUSTER_REPLICATION_CLASS", (String)"SimpleStrategy");
        String statement = "CREATE KEYSPACE IF NOT EXISTS " + keySpace + " WITH replication = {'class': '" + repClass + "', 'replication_factor': " + repFactor + "};";
        logger.info("......keyspace created...");
        session.execute(statement);
        session = cluster.connect(keySpace);
        if (session != null) {
            logger.info("......keyspace conection status = OK");
            this.createArchiveTableSchema(session);
        }
        return session;
    }

    protected void createArchiveTableSchema(Session session) {
        logger.info("CREATE TABLE IF NOT EXISTS snapshots (snapshot text, data blob, PRIMARY KEY (snapshot))");
        session.execute("CREATE TABLE IF NOT EXISTS snapshots (snapshot text, data blob, PRIMARY KEY (snapshot))");
        logger.info("CREATE TABLE IF NOT EXISTS snapshots_by_uniqueid (uniqueid text,snapshot text, PRIMARY KEY(uniqueid, snapshot));");
        session.execute("CREATE TABLE IF NOT EXISTS snapshots_by_uniqueid (uniqueid text,snapshot text, PRIMARY KEY(uniqueid, snapshot));");
        logger.info("CREATE TABLE IF NOT EXISTS snapshots_by_modified (modified date,snapshot text,PRIMARY KEY(modified, snapshot));");
        session.execute("CREATE TABLE IF NOT EXISTS snapshots_by_modified (modified date,snapshot text,PRIMARY KEY(modified, snapshot));");
        logger.info("CREATE TABLE IF NOT EXISTS documents (md5 text, sort_id int, data_id text, PRIMARY KEY (md5,sort_id))");
        session.execute("CREATE TABLE IF NOT EXISTS documents (md5 text, sort_id int, data_id text, PRIMARY KEY (md5,sort_id))");
        logger.info("CREATE TABLE IF NOT EXISTS snapshots_by_document (md5 text,snapshot text, PRIMARY KEY(md5, snapshot));");
        session.execute("CREATE TABLE IF NOT EXISTS snapshots_by_document (md5 text,snapshot text, PRIMARY KEY(md5, snapshot));");
        logger.info("CREATE TABLE IF NOT EXISTS documents_data (data_id text, data blob, PRIMARY KEY (data_id))");
        session.execute("CREATE TABLE IF NOT EXISTS documents_data (data_id text, data blob, PRIMARY KEY (data_id))");
    }
}

