/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ArchiveEvent;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DocumentSplitter;
import org.imixs.archive.service.scheduler.SyncService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.WorkflowKernel;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

/*
 * Exception performing whole class analysis ignored.
 */
@Stateless
public class DataService {
    public static final String ITEM_MD5_CHECKSUM = "md5checksum";
    private static final String REGEX_SNAPSHOTID = "([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}-[0-9]{13,15})";
    private static final String REGEX_OLD_SNAPSHOTID = "([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)";
    private static Logger logger = Logger.getLogger(DataService.class.getName());
    public static final String COLUMN_SNAPSHOT = "snapshot";
    public static final String COLUMN_MODIFIED = "modified";
    public static final String COLUMN_UNIQUEID = "uniqueid";
    public static final String COLUMN_DATA = "data";
    public static final String COLUMN_MD5 = "md5";
    public static final String STATEMENT_UPSET_SNAPSHOTS = "insert into snapshots (snapshot, data) values (?, ?)";
    public static final String STATEMENT_UPSET_SNAPSHOTS_BY_UNIQUEID = "insert into snapshots_by_uniqueid (uniqueid, snapshot) values (?, ?)";
    public static final String STATEMENT_UPSET_SNAPSHOTS_BY_MODIFIED = "insert into snapshots_by_modified (modified, snapshot) values (?, ?)";
    public static final String STATEMENT_UPSET_DOCUMENTS = "insert into documents (md5, sort_id, data_id) values (?, ?, ?)";
    public static final String STATEMENT_UPSET_DOCUMENTS_DATA = "insert into documents_data (data_id, data) values (?, ?)";
    public static final String STATEMENT_UPSET_SNAPSHOTS_BY_DOCUMENT = "insert into snapshots_by_document (md5, snapshot) values (?, ?)";
    public static final String STATEMENT_SELECT_SNAPSHOT = "select * from snapshots where snapshot='?'";
    public static final String STATEMENT_SELECT_METADATA = "select * from snapshots where snapshot='0'";
    public static final String STATEMENT_SELECT_SNAPSHOT_ID = "select snapshot from snapshots where snapshot='?'";
    public static final String STATEMENT_SELECT_MD5 = "select md5 from documents where md5='?'";
    public static final String STATEMENT_SELECT_DOCUMENTS = "select * from documents where md5='?'";
    public static final String STATEMENT_SELECT_DOCUMENTS_DATA = "select * from documents_data where data_id='?'";
    public static final String STATEMENT_SELECT_SNAPSHOTS_BY_UNIQUEID = "select * from snapshots_by_uniqueid where uniqueid='?'";
    public static final String STATEMENT_SELECT_SNAPSHOTS_BY_MODIFIED = "select * from snapshots_by_modified where modified='?'";
    @EJB
    ClusterService clusterService;
    @EJB
    SyncService schedulerService;
    @Inject
    protected Event<ArchiveEvent> events;

    public void saveSnapshot(ItemCollection snapshot, Session session) throws ArchiveException {
        String snapshotID = snapshot.getUniqueID();
        if (!DataService.isSnapshotID((String)snapshotID)) {
            throw new IllegalArgumentException("unexpected '$snapshotid' fromat: " + snapshotID);
        }
        logger.finest("......save document" + snapshotID);
        if (!snapshot.hasItem("$modified")) {
            throw new IllegalArgumentException("missing item '$modified' for snapshot " + snapshotID);
        }
        String originUnqiueID = DataService.getUniqueID((String)snapshotID);
        this.extractDocuments(snapshot, session);
        session.execute((Statement)new SimpleStatement("insert into snapshots (snapshot, data) values (?, ?)", new Object[]{snapshot.getUniqueID(), ByteBuffer.wrap(DataService.getRawData((ItemCollection)snapshot))}));
        session.execute((Statement)new SimpleStatement("insert into snapshots_by_uniqueid (uniqueid, snapshot) values (?, ?)", new Object[]{originUnqiueID, snapshot.getUniqueID()}));
        com.datastax.driver.core.LocalDate ld = com.datastax.driver.core.LocalDate.fromMillisSinceEpoch((long)snapshot.getItemValueDate("$modified").getTime());
        session.execute((Statement)new SimpleStatement("insert into snapshots_by_modified (modified, snapshot) values (?, ?)", new Object[]{ld, snapshot.getUniqueID()}));
        if (this.events != null) {
            this.events.fire((Object)new ArchiveEvent(snapshot, 1));
        } else {
            logger.warning("Missing CDI support for Event<ArchiveEvent> !");
        }
    }

    private void extractDocuments(ItemCollection itemCol, Session session) throws ArchiveException {
        byte[] empty = new byte[]{};
        List files = itemCol.getFileData();
        for (FileData fileData : files) {
            try {
                logger.finest("... extract fileData objects: " + files.size() + " fileData objects found....");
                if (fileData.getContent() == null || fileData.getContent().length <= 0) continue;
                String md5 = fileData.generateMD5();
                String sql = "select md5 from documents where md5='?'";
                sql = sql.replace("'?'", "'" + md5 + "'");
                logger.finest("......search MD5 entry: " + sql);
                ResultSet rs = session.execute(sql);
                Row row = rs.one();
                if (row == null) {
                    this.storeDocument(md5, fileData.getContent(), session);
                } else {
                    logger.finest("......update fildata not necessary because object: " + md5 + " is already stored!");
                }
                session.execute((Statement)new SimpleStatement("insert into snapshots_by_document (md5, snapshot) values (?, ?)", new Object[]{md5, itemCol.getUniqueID()}));
                logger.finest("drop content for file '" + fileData.getName() + "'");
                itemCol.addFileData(new FileData(fileData.getName(), empty, fileData.getContentType(), fileData.getAttributes()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new ArchiveException("MD5_ERROR", "can not compute md5 of document - " + e.getMessage());
            }
        }
    }

    private void storeDocument(String md5, byte[] data, Session session) {
        DocumentSplitter documentSplitter = new DocumentSplitter(data);
        Iterator it = documentSplitter.iterator();
        int sort_id = 0;
        while (it.hasNext()) {
            String data_id = WorkflowKernel.generateUniqueID();
            logger.finest("......write new 1mb data block: sort_id=" + sort_id + " data_id=" + data_id);
            byte[] chunk = (byte[])it.next();
            session.execute((Statement)new SimpleStatement("insert into documents_data (data_id, data) values (?, ?)", new Object[]{data_id, ByteBuffer.wrap(chunk)}));
            session.execute((Statement)new SimpleStatement("insert into documents (md5, sort_id, data_id) values (?, ?, ?)", new Object[]{md5, sort_id, data_id}));
            ++sort_id;
        }
        logger.finest("......stored filedata object: " + md5);
    }

    private void mergeDocumentData(ItemCollection itemCol, Session session) throws ArchiveException {
        List files = itemCol.getFileData();
        for (FileData fileData : files) {
            logger.finest("... merge fileData objects: " + files.size() + " fileData objects defined....");
            if (fileData.getContent() != null && fileData.getContent().length != 0) continue;
            ItemCollection customAttributes = new ItemCollection(fileData.getAttributes());
            String md5 = customAttributes.getItemValueString("md5checksum");
            String sql = "select * from documents where md5='?'";
            sql = sql.replace("'?'", "'" + md5 + "'");
            logger.finest("......search MD5 entry: " + sql);
            ResultSet rs = session.execute(sql);
            Iterator resultIter = rs.iterator();
            ByteArrayOutputStream bOutput = new ByteArrayOutputStream(0x100000);
            try {
                while (resultIter.hasNext()) {
                    Row row = (Row)resultIter.next();
                    int sort_id = row.getInt(1);
                    String data_id = row.getString(2);
                    logger.finest("......load 1mb data block: sort_id=" + sort_id + " data_id=" + data_id);
                    String sql_data = "select * from documents_data where data_id='?'";
                    sql_data = sql_data.replace("'?'", "'" + data_id + "'");
                    ResultSet rs_data = session.execute(sql_data);
                    Row row_data = rs_data.one();
                    if (row_data != null) {
                        logger.finest("......merge data block: " + md5 + " sort_id: " + sort_id + " data_id: " + data_id + "...");
                        ByteBuffer byteDataBlock = row_data.getBytes(1);
                        bOutput.write(byteDataBlock.array());
                        continue;
                    }
                    logger.warning("Document Data missing: " + itemCol.getUniqueID() + " MD5:" + md5 + " sort_id: " + sort_id + " data_id: " + data_id);
                }
                byte[] allData = bOutput.toByteArray();
                logger.finest("......collected full data block: " + md5 + " size: " + allData.length + "...");
                itemCol.addFileData(new FileData(fileData.getName(), allData, fileData.getContentType(), fileData.getAttributes()));
                bOutput.close();
            }
            catch (IOException e) {
                throw new ArchiveException("INVALID_DOCUMENT_OBJECT", "failed to load document data: " + e.getMessage(), (Exception)e);
            }
        }
    }

    public boolean existSnapshot(String snapshotID, Session session) {
        String sql = "select snapshot from snapshots where snapshot='?'";
        sql = sql.replace("'?'", "'" + snapshotID + "'");
        logger.finest("......search snapshot id: " + sql);
        ResultSet rs = session.execute(sql);
        Row row = rs.one();
        return row != null;
    }

    public ItemCollection loadSnapshot(String snapshotID, Session session) throws ArchiveException {
        return this.loadSnapshot(snapshotID, true, session);
    }

    public ItemCollection loadSnapshot(String snapshotID, boolean mergeDocuments, Session session) throws ArchiveException {
        ItemCollection snapshot = new ItemCollection();
        String sql = "select * from snapshots where snapshot='?'";
        sql = sql.replace("'?'", "'" + snapshotID + "'");
        logger.finest("......search snapshot id: " + sql);
        ResultSet rs = session.execute(sql);
        Row row = rs.one();
        if (row != null) {
            ByteBuffer data = row.getBytes("data");
            if (data.hasArray()) {
                snapshot = DataService.getItemCollection((byte[])data.array());
                this.mergeDocumentData(snapshot, session);
            }
        } else {
            snapshot = new ItemCollection();
        }
        return snapshot;
    }

    public ItemCollection loadMetadata(Session session) throws ArchiveException {
        return this.loadSnapshot("0", session);
    }

    public List<String> loadSnapshotsByUnqiueID(String uniqueID, Session session) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select * from snapshots_by_uniqueid where uniqueid='?'";
        sql = sql.replace("'?'", "'" + uniqueID + "'");
        logger.finest("......search snapshot id: " + sql);
        ResultSet rs = session.execute(sql);
        for (Row row : rs) {
            String snapshotID = row.getString(1);
            result.add(snapshotID);
        }
        return result;
    }

    public List<String> loadSnapshotsByDate(LocalDate date, Session session) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "select * from snapshots_by_modified where modified='?'";
        sql = sql.replace("'?'", "'" + date + "'");
        logger.finest("......SQL: " + sql);
        ResultSet rs = session.execute(sql);
        for (Row row : rs) {
            String snapshotID = row.getString(1);
            result.add(snapshotID);
        }
        return result;
    }

    public void saveMetadata(ItemCollection metadata, Session session) throws ArchiveException {
        session.execute((Statement)new SimpleStatement("insert into snapshots (snapshot, data) values (?, ?)", new Object[]{"0", ByteBuffer.wrap(DataService.getRawData((ItemCollection)metadata))}));
    }

    public void deleteSnapshot(ItemCollection itemCol, Session session) throws ArchiveException {
        logger.warning("need to delete snapshot and references");
        logger.warning("need to delete document content if no longer refered by other snapshots");
    }

    public static byte[] getRawData(ItemCollection itemCol) throws ArchiveException {
        byte[] data = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDocument.class});
            Marshaller m = context.createMarshaller();
            XMLDocument xmlDocument = XMLDocumentAdapter.getDocument((ItemCollection)itemCol);
            m.marshal((Object)xmlDocument, (OutputStream)outputStream);
            data = outputStream.toByteArray();
        }
        catch (JAXBException e) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", e.getMessage(), (Exception)((Object)e));
        }
        return data;
    }

    public static ItemCollection getItemCollection(byte[] source) throws ArchiveException {
        ByteArrayInputStream bis = new ByteArrayInputStream(source);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{XMLDocument.class});
            Unmarshaller m = context.createUnmarshaller();
            Object jaxbObject = m.unmarshal((InputStream)bis);
            if (jaxbObject == null) {
                throw new RuntimeException("readCollection error - wrong xml file format - unable to read content!");
            }
            XMLDocument xmlDocument = (XMLDocument)jaxbObject;
            return XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
        }
        catch (JAXBException e) {
            throw new ArchiveException("INVALID_DOCUMENT_OBJECT", e.getMessage(), (Exception)((Object)e));
        }
    }

    public static boolean isSnapshotID(String uid) {
        boolean valid = uid.matches("([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}-[0-9]{13,15})");
        if (!valid) {
            logger.fine("...validate old snapshot id format...");
            valid = uid.matches("([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)");
        }
        return valid;
    }

    public static String getUniqueID(String snapshotID) {
        if (snapshotID != null && snapshotID.contains("-")) {
            return snapshotID.substring(0, snapshotID.lastIndexOf("-"));
        }
        return null;
    }

    public static long getSnapshotTime(String snapshotID) {
        if (snapshotID != null && snapshotID.contains("-")) {
            String sTime = snapshotID.substring(snapshotID.lastIndexOf("-") + 1);
            return Long.parseLong(sTime);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateSize(XMLDocument xmldoc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(xmldoc);
            oos.close();
            long l = baos.size();
            return l;
        }
        catch (IOException e) {
            logger.warning("...unable to calculate document size!");
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    logger.warning("failed to close stream");
                    e.printStackTrace();
                }
            }
        }
        return 0L;
    }

    public static String getSyncPointISO(long point) {
        SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Date date = new Date(point);
        return dt.format(date);
    }
}

