/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.scheduler;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.scheduler.RemoteAPIService;
import org.imixs.archive.service.scheduler.SyncService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class RestoreService {
    public static final String TIMER_ID_RESTORESERVICE = "IMIXS_ARCHIVE_RESTORE_TIMER";
    public static final long TIMER_INTERVAL_DURATION = 60000L;
    public static final String ITEM_RESTORE_FROM = "restore.from";
    public static final String ITEM_RESTORE_TO = "restore.to";
    public static final String ITEM_RESTORE_SYNCPOINT = "restore.$sync_point";
    public static final String ITEM_RESTORE_SYNCCOUNT = "restore.$sync_count";
    public static final String ITEM_RESTORE_SYNCERRORS = "restore.$sync_errors";
    public static final String ITEM_RESTORE_SYNCSIZE = "restore.$sync_size";
    public static final String ITEM_RESTORE_OPTIONS = "restore.options";
    private static Logger logger = Logger.getLogger(RestoreService.class.getName());
    @EJB
    DataService dataService;
    @EJB
    ClusterService clusterService;
    @EJB
    MessageService messageService;
    @Resource
    TimerService timerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long restoreFrom, long restoreTo, List<Map> options) throws ArchiveException {
        Timer timer = null;
        timer = this.findTimer();
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                this.messageService.logMessage("Failed to stop existing timer - " + e.getMessage());
                throw new ArchiveException(SyncService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        logger.info("...starting scheduler restore-service...");
        Session session = null;
        Cluster cluster = null;
        try {
            logger.info("...... restore from=" + DataService.getSyncPointISO((long)restoreFrom));
            logger.info("...... restore   to=" + DataService.getSyncPointISO((long)restoreTo));
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            ItemCollection metaData = this.dataService.loadMetadata(session);
            metaData.setItemValue(ITEM_RESTORE_FROM, (Object)restoreFrom);
            metaData.setItemValue(ITEM_RESTORE_TO, (Object)restoreTo);
            metaData.setItemValue(ITEM_RESTORE_SYNCPOINT, (Object)restoreFrom);
            metaData.setItemValue(ITEM_RESTORE_SYNCCOUNT, (Object)0);
            metaData.setItemValue(ITEM_RESTORE_SYNCSIZE, (Object)0);
            metaData.setItemValue(ITEM_RESTORE_OPTIONS, options);
            this.dataService.saveMetadata(metaData, session);
            timer = this.timerService.createTimer(new Date(), 60000L, (Serializable)((Object)TIMER_ID_RESTORESERVICE));
            if (timer != null) {
                this.messageService.logMessage("Timer started.");
            }
        }
        catch (Exception e) {
            logger.warning("...Failed to update metadata: " + e.getMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    void onTimeout(Timer timer) throws Exception {
        Session session = null;
        Cluster cluster = null;
        ItemCollection metadata = null;
        int restoreCount = 0;
        int restoreErrors = 0;
        long restoreSize = 0L;
        long startTime = System.currentTimeMillis();
        try {
            cluster = this.clusterService.getCluster();
            session = this.clusterService.getArchiveSession(cluster);
            metadata = this.dataService.loadMetadata(session);
            long syncpoint = metadata.getItemValueLong(ITEM_RESTORE_SYNCPOINT);
            List options = this.getOptions(metadata);
            LocalDateTime localDateSyncPoint = new Date(syncpoint).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            long restoreFrom = metadata.getItemValueLong(ITEM_RESTORE_FROM);
            long restoreTo = metadata.getItemValueLong(ITEM_RESTORE_TO);
            LocalDateTime localDateRestoreTo = new Date(restoreTo).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            logger.info("......starting restore:    from " + DataService.getSyncPointISO((long)restoreFrom) + " to " + DataService.getSyncPointISO((long)restoreTo));
            logger.info("......starting syncpoint:  " + DataService.getSyncPointISO((long)syncpoint));
            while (localDateRestoreTo.isAfter(localDateSyncPoint)) {
                List snapshotIDs = this.dataService.loadSnapshotsByDate(localDateSyncPoint.toLocalDate(), session);
                if (!snapshotIDs.isEmpty()) {
                    logger.finest("......analyze snapshotIDs from " + localDateSyncPoint);
                    for (String snapshotID : snapshotIDs) {
                        String latestSnapshot = this.findLatestSnapshotID(snapshotID, restoreFrom, restoreTo, session);
                        if (latestSnapshot != null) {
                            String remoteSnapshotID = RemoteAPIService.readSnapshotIDByUniqueID((String)DataService.getUniqueID((String)latestSnapshot));
                            if (latestSnapshot.equals(remoteSnapshotID)) {
                                logger.finest("......no need to restore - snapshot:" + latestSnapshot + " is up to date!");
                                continue;
                            }
                            if (!this.matchFilterOptions(latestSnapshot, options, session)) continue;
                            long _tmpSize = -1L;
                            try {
                                logger.finest("......restoring: " + latestSnapshot);
                                ItemCollection snapshot = this.dataService.loadSnapshot(latestSnapshot, session);
                                _tmpSize = DataService.calculateSize((XMLDocument)XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
                                logger.finest("......size=: " + _tmpSize);
                                RemoteAPIService.restoreSnapshot((ItemCollection)snapshot);
                                restoreSize += _tmpSize;
                                ++restoreCount;
                                snapshot = null;
                            }
                            catch (Exception e) {
                                logger.severe("...Failed to restore '" + latestSnapshot + "' (" + MessageService.userFriendlyBytes((long)_tmpSize) + ") - " + e.getMessage());
                                ++restoreErrors;
                            }
                            continue;
                        }
                        logger.warning(".... unexpected data situation:  we found no latest snapthost matching our restore time range!");
                    }
                }
                localDateSyncPoint = localDateSyncPoint.plusDays(1L);
                metadata.setItemValue(ITEM_RESTORE_SYNCPOINT, (Object)localDateSyncPoint);
                metadata.setItemValue(ITEM_RESTORE_SYNCCOUNT, (Object)restoreCount);
                metadata.setItemValue(ITEM_RESTORE_SYNCSIZE, (Object)restoreSize);
                metadata.setItemValue(ITEM_RESTORE_SYNCERRORS, (Object)restoreErrors);
                this.dataService.saveMetadata(metadata, session);
            }
            logger.info("...restore finished in: " + (System.currentTimeMillis() - startTime) + "ms");
            logger.info(".......final syncpoint: " + localDateSyncPoint);
            logger.info(".......total count:" + restoreCount);
            logger.info(".......total size:" + MessageService.userFriendlyBytes((long)restoreSize));
            logger.info(".......total errors:" + restoreErrors);
            timer.cancel();
        }
        catch (Exception e) {
            logger.severe("Failed to restore data: " + e.getMessage());
            timer.cancel();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    String findLatestSnapshotID(String snapshotID, long restoreFrom, long restoreTo, Session session) {
        String latestSnapshot = null;
        List _tmpSnapshots = this.dataService.loadSnapshotsByUnqiueID(DataService.getUniqueID((String)snapshotID), session);
        for (String _tmpSnapshotID : _tmpSnapshots) {
            logger.finest(".......           :" + _tmpSnapshotID);
        }
        for (String _tmpSnapshotID : _tmpSnapshots) {
            long _tmpSnapshotTime = DataService.getSnapshotTime((String)_tmpSnapshotID);
            if (_tmpSnapshotTime >= restoreFrom && _tmpSnapshotTime <= restoreTo) {
                if (_tmpSnapshotTime <= DataService.getSnapshotTime(latestSnapshot)) continue;
                latestSnapshot = _tmpSnapshotID;
                continue;
            }
            logger.finest(".... skip snapshot (out of sync range): " + _tmpSnapshotID);
        }
        return latestSnapshot;
    }

    boolean matchFilterOptions(String snapshotID, List<ItemCollection> options, Session session) throws ArchiveException {
        ItemCollection _tmp_snapshot_data = null;
        if (options == null || options.size() == 0) {
            return true;
        }
        _tmp_snapshot_data = this.dataService.loadSnapshot(snapshotID, false, session);
        for (ItemCollection option : options) {
            String itemName = option.getItemValueString("name");
            Pattern regexPattern = Pattern.compile(option.getItemValueString("filter").trim());
            List valueList = _tmp_snapshot_data.getItemValueList(itemName, String.class);
            for (String value : valueList) {
                if (regexPattern.matcher(value).find()) continue;
                logger.fine(" snapshot value '" + value + "' did not match filter option '" + regexPattern + "'");
                _tmp_snapshot_data = null;
                return false;
            }
        }
        _tmp_snapshot_data = null;
        return true;
    }

    public Timer findTimer() {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!TIMER_ID_RESTORESERVICE.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    public List<ItemCollection> getOptions(ItemCollection metaData) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List mapOrderItems = metaData.getItemValue(ITEM_RESTORE_OPTIONS);
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            result.add(itemCol);
        }
        return result;
    }

    public void setOptions(List<ItemCollection> options, ItemCollection metaData) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (options != null) {
            logger.fine("Convert option items into Map...");
            for (ItemCollection orderItem : options) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            metaData.replaceItemValue(ITEM_RESTORE_OPTIONS, mapOrderItems);
        }
    }
}

