/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.rest;

import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.ItemCollection;

@Path(value="/metadata")
@Produces(value={"application/json", "text/html", "text/xml"})
@Stateless
public class MetatdataRestService {
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/")
    public String getSyncpoint() {
        Object session = null;
        Object cluster = null;
        try {
            logger.info("...read metadata...");
            ItemCollection metadata = this.dataService.loadMetadata();
            String result = "syncpoint=" + metadata.getItemValueString("sync.point");
            String string = result = result + "\ncount=" + metadata.getItemValueString("sync.count");
            return string;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            String string = "NO DATA";
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    static {
        logger = Logger.getLogger(MetatdataRestService.class.getName());
    }
}

