/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.export.ExportService;
import org.imixs.archive.service.resync.SyncService;

@ApplicationPath(value="api")
public class ImixsArchiveApp
extends Application {
    @Inject
    SyncService syncService;
    @Inject
    MessageService messageService;
    @Inject
    ExportService exportService;

    @PostConstruct
    public void initialize() {
        if (this.syncService != null) {
            try {
                this.syncService.start();
                this.exportService.startScheduler();
            }
            catch (ArchiveException e) {
                this.messageService.logMessage("sync", "Failed to start scheduler - " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

