/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.rest;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.event.Observes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.imixs.archive.service.cassandra.ArchiveEvent;
import org.imixs.archive.service.rest.MetricService;
import org.imixs.workflow.exceptions.AccessDeniedException;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
@Startup
@Path(value="metrics")
public class MetricService {
    private ConcurrentHashMap<String, AtomicLong> metricTotalProcessing = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AtomicLong> metricTotalDocuments = new ConcurrentHashMap();
    private static Logger logger = Logger.getLogger(MetricService.class.getName());

    @PostConstruct
    public void init() {
        this.metricTotalProcessing = new ConcurrentHashMap();
        this.metricTotalDocuments = new ConcurrentHashMap();
    }

    @GET
    @Produces(value={"text/plain; version=0.0.4"})
    public Response getMetrics() {
        1 stream = new /* Unavailable Anonymous Inner Class!! */;
        return Response.ok((Object)stream).build();
    }

    public void onProcessingEvent(@Observes ArchiveEvent archiveEvent) throws AccessDeniedException {
        if (archiveEvent == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (1 == archiveEvent.getEventType()) {
            String metric = MetricService.buildProcessingMetric((ArchiveEvent)archiveEvent);
            AtomicLong counter = (AtomicLong)this.metricTotalProcessing.get(metric);
            if (counter == null) {
                counter = new AtomicLong();
            }
            counter.incrementAndGet();
            this.metricTotalProcessing.put(metric, counter);
            logger.fine("...metric " + metric + " collected in " + (System.currentTimeMillis() - l) + "ms");
        }
    }

    public void onDocumentEvent(@Observes ArchiveEvent documentEvent) throws AccessDeniedException {
        if (documentEvent == null) {
            return;
        }
        long l = System.currentTimeMillis();
        String metric = MetricService.buildDocumentMetric((ArchiveEvent)documentEvent);
        if (metric == null) {
            return;
        }
        AtomicLong counter = (AtomicLong)this.metricTotalDocuments.get(metric);
        if (counter == null) {
            counter = new AtomicLong();
        }
        counter.incrementAndGet();
        this.metricTotalDocuments.put(metric, counter);
        logger.fine("...metric " + metric + " collected in " + (System.currentTimeMillis() - l) + "ms");
    }

    private static String buildDocumentMetric(ArchiveEvent event) {
        if (1 == event.getEventType()) {
            return "documents_total{method=\"archive\"}";
        }
        if (2 == event.getEventType()) {
            return "documents_total{method=\"restore\"}";
        }
        if (3 == event.getEventType()) {
            return "documents_total{method=\"delete\"}";
        }
        return null;
    }

    private static String buildProcessingMetric(ArchiveEvent event) {
        String metric = "workitems_processed_total";
        metric = metric + "{";
        metric = metric + "type=\"" + event.getDocument().getType() + "\",";
        metric = metric + "modelversion=\"" + event.getDocument().getModelVersion() + "\",";
        metric = metric + "task=\"" + event.getDocument().getTaskID() + "\",";
        metric = metric + "event=\"" + event.getDocument().getItemValueInteger("$lastevent") + "\",";
        metric = metric + "workflowgroup=\"" + event.getDocument().getItemValueString("$workflowgroup") + "\",";
        metric = metric + "workflowstatus=\"" + event.getDocument().getItemValueString("$workflowstatus") + "\"";
        metric = metric + "} ";
        return metric;
    }

    static /* synthetic */ ConcurrentHashMap access$000(MetricService x0) {
        return x0.metricTotalDocuments;
    }

    static /* synthetic */ ConcurrentHashMap access$100(MetricService x0) {
        return x0.metricTotalProcessing;
    }
}

