/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.FileData;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.InvalidAccessException;
import org.imixs.workflow.xml.XMLDataCollectionAdapter;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Path(value="/archive")
@Produces(value={"text/html", "application/xml", "application/json", "text/xml"})
@Stateless
public class ArchiveRestService {
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Context
    private static HttpServletRequest servletRequest;
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/snapshot/{id : ([0-9a-f]{8}-.*|[0-9a-f]{11}-.*)}")
    public Response getSnapshot(@PathParam(value="id") String id, @QueryParam(value="format") String format) {
        Object session = null;
        Object cluster = null;
        try {
            logger.finest("...read snapshot...");
            ItemCollection snapshot = this.dataService.loadSnapshot(id);
            Response response = this.convertResult(snapshot, format);
            return response;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            Response response = null;
            return response;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/metadata")
    public Response getMetadata(@QueryParam(value="format") String format) {
        Object session = null;
        Object cluster = null;
        try {
            logger.finest("...read snapshot...");
            ItemCollection metadata = this.dataService.loadMetadata();
            Response response = this.convertResult(metadata, format);
            return response;
        }
        catch (Exception e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            Response response = null;
            return response;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    @GET
    @Path(value="/md5/{md5}")
    @Produces(value={"application/octet-stream"})
    public Response getSnapshotFileByMD5Checksum(@PathParam(value="md5") @Encoded String md5, @QueryParam(value="contentType") String contentType) {
        boolean debug = logger.isLoggable(Level.FINE);
        byte[] fileContent = null;
        try {
            if (debug) {
                logger.finest("...read snapshot...");
            }
            fileContent = this.dataService.loadFileContent(md5);
        }
        catch (ArchiveException e) {
            logger.warning("...failed to load file: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            if (fileContent != null && fileContent.length > 0) {
                Response.ResponseBuilder builder = Response.ok((Object)fileContent, (String)contentType);
                return builder.build();
            }
            logger.warning("ArchiveRestService unable to open file by md5 checksum: '" + md5 + "'");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.severe("ArchiveRestService unable to open file by md5 checksum: '" + md5 + "' - error: " + e.getMessage());
            if (debug) {
                e.printStackTrace();
            }
            logger.severe("ArchiveRestService unable to open file by md5 checksum: '" + md5 + "'");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/snapshot/{id}/file/{file}")
    public Response getSnapshotFileByName(@PathParam(value="snapshotid") String id, @PathParam(value="file") @Encoded String file, @Context UriInfo uriInfo) {
        Object session = null;
        Object cluster = null;
        ItemCollection snapshot = null;
        FileData fileData = null;
        try {
            logger.finest("...read snapshot...");
            snapshot = this.dataService.loadSnapshot(id, false);
            String fileNameUTF8 = URLDecoder.decode(file, "UTF-8");
            String fileNameISO = URLDecoder.decode(file, "ISO-8859-1");
            fileData = snapshot.getFileData(fileNameUTF8);
            if (fileData == null) {
                fileData = snapshot.getFileData(fileNameISO);
            }
            if (fileData == null) {
                fileData = snapshot.getFileData(file);
            }
            if (fileData != null) {
                fileData = this.dataService.loadFileData(fileData);
            }
        }
        catch (UnsupportedEncodingException | ArchiveException e) {
            logger.warning("...Failed to load file: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
        try {
            if (fileData != null) {
                Response.ResponseBuilder builder = Response.ok((Object)fileData.getContent(), (String)fileData.getContentType());
                return builder.build();
            }
            logger.warning("ArchiveRestService unable to open file: '" + file + "' in workitem '" + id + "' - error: Filename not found!");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.severe("ArchiveRestService unable to open file: '" + file + "' in workitem '" + id + "' - error: " + e.getMessage());
            e.printStackTrace();
            logger.severe("ArchiveRestService unable to open file: '" + file + "' in workitem '" + id + "'");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml", "text/xml"})
    public Response postSnapshot(XMLDocument xmlDocument) {
        Object session = null;
        Object cluster = null;
        ItemCollection snapshot = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
        try {
            logger.finest("...write snapshot...");
            this.dataService.saveSnapshot(snapshot);
            snapshot.removeItem("$error_code");
            snapshot.removeItem("$error_message");
        }
        catch (ArchiveException e) {
            logger.warning("...Failed to initalize imixsarchive keyspace: " + e.getMessage());
            snapshot = this.addErrorMessage((Exception)((Object)e), snapshot);
            Response response = null;
            return response;
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
        try {
            if (snapshot.hasItem("$error_code")) {
                return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)snapshot), (String)"application/xml").status(Response.Status.NOT_ACCEPTABLE).build();
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }

    private Response convertResult(ItemCollection workitem, String format) {
        if (workitem == null) {
            workitem = new ItemCollection();
        }
        if ("json".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, null)).header("Content-Type", (Object)"application/json").build();
        }
        if ("xml".equals(format)) {
            return Response.ok((Object)XMLDataCollectionAdapter.getDataCollection((ItemCollection)workitem, null)).header("Content-Type", (Object)"application/xml").build();
        }
        return Response.ok((Object)XMLDocumentAdapter.getDocument((ItemCollection)workitem)).build();
    }

    private ItemCollection addErrorMessage(Exception pe, ItemCollection aworkitem) {
        if (pe instanceof RuntimeException && pe.getCause() != null) {
            pe = (RuntimeException)pe.getCause();
        }
        if (pe instanceof InvalidAccessException) {
            aworkitem.replaceItemValue("$error_code", (Object)((InvalidAccessException)pe).getErrorCode());
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        } else {
            aworkitem.replaceItemValue("$error_code", (Object)"INTERNAL ERROR");
            aworkitem.replaceItemValue("$error_message", (Object)pe.getMessage());
        }
        return aworkitem;
    }

    static {
        logger = Logger.getLogger(ArchiveRestService.class.getName());
    }
}

