/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.MessageService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.resync.SyncService;
import org.imixs.workflow.ItemCollection;

@Named
@RequestScoped
public class ClusterDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ClusterDataController.class.getName());
    String syncSizeUnit = null;
    ItemCollection metaData = null;
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Inject
    SyncService syncService;
    @Inject
    MessageService messageService;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_CONTACTPOINTS", defaultValue="")
    String contactPoint;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_KEYSPACE", defaultValue="")
    String keySpace;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_REPLICATION_FACTOR", defaultValue="1")
    String repFactor;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_REPLICATION_CLASS", defaultValue="SimpleStrategy")
    String repClass;
    @Inject
    @ConfigProperty(name="WORKFLOW_SERVICE_ENDPOINT", defaultValue="")
    String workflowServiceEndpoint;

    @PostConstruct
    void init() {
        try {
            this.metaData = this.dataService.loadMetadata();
        }
        catch (ArchiveException e) {
            logger.severe("Failed to load meta data!");
            e.printStackTrace();
        }
    }

    public boolean isConnected() {
        return this.clusterService.getSession() != null;
    }

    public void start() {
        try {
            this.syncService.start();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public boolean isRunning() {
        return this.syncService.isRunning();
    }

    public void cancel() {
        try {
            this.syncService.cancel();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public Date getSyncPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("sync.point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public long getSyncCount() {
        return this.metaData.getItemValueLong("sync.count");
    }

    public String getSyncSize() {
        long l = this.metaData.getItemValueLong("sync.size");
        String result = this.messageService.userFriendlyBytes(l);
        String[] parts = result.split(" ");
        this.syncSizeUnit = parts[1];
        return parts[0];
    }

    public String getSyncSizeUnit() {
        return this.syncSizeUnit;
    }

    public String getContactPoints() {
        return this.contactPoint;
    }

    public String getKeySpace() {
        return this.keySpace;
    }

    public String getReplicationFactor() {
        return this.repFactor;
    }

    public String getReplicationClass() {
        return this.repClass;
    }

    public String getServiceEndpoint() {
        return this.workflowServiceEndpoint;
    }

    public List<String> getMessages() {
        List messageLog = this.messageService.getMessages("sync");
        ArrayList<String> result = new ArrayList<String>();
        for (String message : messageLog) {
            result.add(message);
        }
        Collections.reverse(result);
        return result;
    }
}

