/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.SyncService;
import org.imixs.melman.RestAPIException;

@Startup
@Singleton
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SyncScheduler {
    @Inject
    @ConfigProperty(name="workflow.sync.interval", defaultValue="1000")
    long interval;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint", defaultValue="")
    String workflowServiceEndpoint;
    @Inject
    SyncService archiveSyncService;
    @Resource
    ManagedScheduledExecutorService scheduler;
    private static Logger logger = Logger.getLogger(SyncScheduler.class.getName());

    @PostConstruct
    public void init() {
        if (this.workflowServiceEndpoint != null && !this.workflowServiceEndpoint.isEmpty()) {
            logger.info("Starting ArchivePushService - inverval=" + this.interval + " ....");
            this.scheduler.scheduleAtFixedRate(() -> this.run(), this.interval, this.interval, TimeUnit.MILLISECONDS);
        }
    }

    public void run() {
        try {
            this.archiveSyncService.releaseDeadLocks();
            this.archiveSyncService.processEventLog();
        }
        catch (NotFoundException | RestAPIException e) {
            logger.warning("unable to process event log: " + e.getMessage());
        }
    }
}

