/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.policies.DefaultRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;

@Singleton
public class ClusterService {
    public static final String KEYSPACE_REGEX = "^[a-z_]*[^-]$";
    public static final String ENV_ARCHIVE_CLUSTER_CONTACTPOINTS = "ARCHIVE_CLUSTER_CONTACTPOINTS";
    public static final String ENV_ARCHIVE_CLUSTER_KEYSPACE = "ARCHIVE_CLUSTER_KEYSPACE";
    public static final String ENV_ARCHIVE_CLUSTER_AUTH_USER = "ARCHIVE_CLUSTER_AUTH_USER";
    public static final String ENV_ARCHIVE_CLUSTER_AUTH_PASSWORD = "ARCHIVE_CLUSTER_AUTH_PASSWORD";
    public static final String ENV_ARCHIVE_CLUSTER_SSL = "ARCHIVE_CLUSTER_SSL";
    public static final String ENV_ARCHIVE_CLUSTER_SSL_TRUSTSTOREPATH = "ARCHIVE_CLUSTER_SSL_TRUSTSTOREPATH";
    public static final String ENV_ARCHIVE_CLUSTER_SSL_TRUSTSTOREPASSWORD = "ARCHIVE_CLUSTER_SSL_TRUSTSTOREPASSWORD";
    public static final String ENV_ARCHIVE_CLUSTER_SSL_KEYSTOREPATH = "ARCHIVE_CLUSTER_SSL_KEYSTOREPATH";
    public static final String ENV_ARCHIVE_CLUSTER_SSL_KEYSTOREPASSWORD = "ARCHIVE_CLUSTER_SSL_KEYSTOREPASSWORD";
    public static final String ENV_ARCHIVE_CLUSTER_REPLICATION_FACTOR = "ARCHIVE_CLUSTER_REPLICATION_FACTOR";
    public static final String ENV_ARCHIVE_CLUSTER_REPLICATION_CLASS = "ARCHIVE_CLUSTER_REPLICATION_CLASS";
    public static final String ENV_WORKFLOW_SERVICE_ENDPOINT = "WORKFLOW_SERVICE_ENDPOINT";
    public static final String ENV_WORKFLOW_SERVICE_USER = "WORKFLOW_SERVICE_USER";
    public static final String ENV_WORKFLOW_SERVICE_PASSWORD = "WORKFLOW_SERVICE_PASSWORD";
    public static final String ENV_WORKFLOW_SERVICE_AUTHMETHOD = "WORKFLOW_SERVICE_AUTHMETHOD";
    public static final String TABLE_SCHEMA_SNAPSHOTS = "CREATE TABLE IF NOT EXISTS snapshots (snapshot text, data blob, PRIMARY KEY (snapshot))";
    public static final String TABLE_SCHEMA_SNAPSHOTS_BY_UNIQUEID = "CREATE TABLE IF NOT EXISTS snapshots_by_uniqueid (uniqueid text,snapshot text, PRIMARY KEY(uniqueid, snapshot));";
    public static final String TABLE_SCHEMA_SNAPSHOTS_BY_MODIFIED = "CREATE TABLE IF NOT EXISTS snapshots_by_modified (modified date,snapshot text,PRIMARY KEY(modified, snapshot));";
    public static final String TABLE_SCHEMA_DOCUMENTS = "CREATE TABLE IF NOT EXISTS documents (md5 text, sort_id int, data_id text, PRIMARY KEY (md5,sort_id))";
    public static final String TABLE_SCHEMA_SNAPSHOTS_BY_DOCUMENT = "CREATE TABLE IF NOT EXISTS snapshots_by_document (md5 text,snapshot text, PRIMARY KEY(md5, snapshot));";
    public static final String TABLE_SCHEMA_DOCUMENTS_DATA = "CREATE TABLE IF NOT EXISTS documents_data (data_id text, data blob, PRIMARY KEY (data_id))";
    private static Logger logger = Logger.getLogger(ClusterService.class.getName());
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_REPLICATION_FACTOR", defaultValue="1")
    String repFactor;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_REPLICATION_CLASS", defaultValue="SimpleStrategy")
    String repClass;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_CONTACTPOINTS", defaultValue="")
    String contactPoint;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_KEYSPACE", defaultValue="")
    String keySpace;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_AUTH_USER", defaultValue="")
    String userid;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_AUTH_PASSWORD", defaultValue="")
    String password;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_SSL", defaultValue="false")
    boolean bUseSSL;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_SSL_TRUSTSTOREPATH", defaultValue="")
    String truststorePath;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_SSL_TRUSTSTOREPASSWORD", defaultValue="")
    String truststorePwd;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_SSL_KEYSTOREPATH", defaultValue="")
    String keystorePath;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_SSL_KEYSTOREPASSWORD", defaultValue="")
    String keystorePwd;
    private Cluster cluster;
    private Session session;

    @PostConstruct
    private void init() {
        try {
            this.cluster = this.initCluster();
            this.session = this.initArchiveSession();
        }
        catch (ArchiveException e) {
            logger.severe("Failed to init achive session!");
            e.printStackTrace();
        }
    }

    @PreDestroy
    private void tearDown() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public Session getSession() {
        if (this.session == null) {
            this.init();
        }
        return this.session;
    }

    private Session initArchiveSession() throws ArchiveException {
        if (!this.isValidKeyspaceName(this.keySpace)) {
            throw new ArchiveException("INVALID_KEYSPACE", "keyspace '" + this.keySpace + "' name invalid.");
        }
        logger.info("......conecting keyspace '" + this.keySpace + "'...");
        try {
            this.session = this.cluster.connect(this.keySpace);
        }
        catch (InvalidQueryException e) {
            logger.warning("......conecting keyspace '" + this.keySpace + "' failed: " + e.getMessage());
            this.session = this.createKeySpace(this.keySpace);
        }
        if (this.session != null) {
            logger.finest("......keyspace conection status = OK");
        }
        return this.session;
    }

    protected Cluster initCluster() throws ArchiveException {
        String[] hosts;
        boolean found = false;
        if (this.contactPoint == null || this.contactPoint.isEmpty()) {
            throw new ArchiveException("MISSING_CONTACTPOINT", "missing cluster contact points - verify configuration!");
        }
        logger.info("...cluster conecting: " + this.contactPoint);
        Cluster.Builder builder = Cluster.builder();
        for (String host : hosts = this.contactPoint.split(",")) {
            try {
                builder.addContactPoint(host);
                found = true;
            }
            catch (IllegalArgumentException e) {
                logger.warning("...the host '" + host + "' is unknown so it will be ignored");
            }
        }
        if (!found) {
            throw new IllegalStateException("All provided hosts are unknown - check cluster status and configuration!");
        }
        builder.withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
        builder.withRetryPolicy((RetryPolicy)DefaultRetryPolicy.INSTANCE);
        if (!this.userid.isEmpty()) {
            builder = builder.withCredentials(this.userid, this.password);
        }
        if (this.bUseSSL) {
            try {
                SSLOptions options = this.createSSLOptions();
                logger.severe("......creating cluster session with SSL...");
                builder.withSSL(options);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                logger.severe("Failed to connect withSSL: " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.cluster = builder.build();
        this.cluster.init();
        logger.info("...cluster conection status = OK");
        return this.cluster;
    }

    private SSLOptions createSSLOptions() throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, KeyManagementException, CertificateException, UnrecoverableKeyException {
        TrustManagerFactory tmf = null;
        if (this.truststorePath != null && !this.truststorePath.isEmpty()) {
            KeyStore tks = KeyStore.getInstance("JKS");
            tks.load(new FileInputStream(new File(this.truststorePath)), this.truststorePwd.toCharArray());
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(tks);
        } else {
            logger.info("SSLOptions without truststore...");
        }
        KeyManagerFactory kmf = null;
        if (null != this.keystorePath && !this.keystorePath.isEmpty()) {
            KeyStore kks = KeyStore.getInstance("JKS");
            kks.load(new FileInputStream(new File(this.keystorePath)), this.keystorePwd.toCharArray());
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(kks, this.keystorePwd.toCharArray());
        } else {
            logger.info("SSLOptions without keystore...");
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf != null ? kmf.getKeyManagers() : null, tmf != null ? tmf.getTrustManagers() : null, new SecureRandom());
        RemoteEndpointAwareJdkSSLOptions sslOptions = RemoteEndpointAwareJdkSSLOptions.builder().withSSLContext(sslContext).build();
        return sslOptions;
    }

    public boolean isValidKeyspaceName(String keySpace) {
        if (keySpace == null || keySpace.isEmpty()) {
            return false;
        }
        return keySpace.matches(KEYSPACE_REGEX);
    }

    protected Session createKeySpace(String keySpace) throws ArchiveException {
        logger.info("......creating new keyspace '" + keySpace + "'...");
        Session session = this.cluster.connect();
        String statement = "CREATE KEYSPACE IF NOT EXISTS " + keySpace + " WITH replication = {'class': '" + this.repClass + "', 'replication_factor': " + this.repFactor + "};";
        session.execute(statement);
        logger.info("......keyspace created...");
        session = this.cluster.connect(keySpace);
        if (session != null) {
            logger.info("......keyspace conection status = OK");
            this.createArchiveTableSchema(session);
        }
        return session;
    }

    protected void createArchiveTableSchema(Session session) {
        logger.info(TABLE_SCHEMA_SNAPSHOTS);
        session.execute(TABLE_SCHEMA_SNAPSHOTS);
        logger.info(TABLE_SCHEMA_SNAPSHOTS_BY_UNIQUEID);
        session.execute(TABLE_SCHEMA_SNAPSHOTS_BY_UNIQUEID);
        logger.info(TABLE_SCHEMA_SNAPSHOTS_BY_MODIFIED);
        session.execute(TABLE_SCHEMA_SNAPSHOTS_BY_MODIFIED);
        logger.info(TABLE_SCHEMA_DOCUMENTS);
        session.execute(TABLE_SCHEMA_DOCUMENTS);
        logger.info(TABLE_SCHEMA_SNAPSHOTS_BY_DOCUMENT);
        session.execute(TABLE_SCHEMA_SNAPSHOTS_BY_DOCUMENT);
        logger.info(TABLE_SCHEMA_DOCUMENTS_DATA);
        session.execute(TABLE_SCHEMA_DOCUMENTS_DATA);
    }
}

