/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Asynchronous;
import javax.ejb.EJBException;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.InvalidAccessException;

@Stateless
@LocalBean
public class SyncService {
    @Inject
    @ConfigProperty(name="workflow.service.endpoint", defaultValue="")
    String workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.user", defaultValue="")
    String workflowServiceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password", defaultValue="")
    String workflowServicePassword;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod", defaultValue="")
    String workflowServiceAuthMethod;
    @Inject
    @ConfigProperty(name="workflow.sync.deadlock", defaultValue="60000")
    long deadLockInterval;
    @Inject
    DataService dataService;
    private static Logger logger = Logger.getLogger(SyncService.class.getName());

    public void processEventLog(EventLogClient eventLogClient, DocumentClient documentClient) throws RestAPIException {
        String topic = null;
        String id = null;
        String ref = null;
        if (documentClient == null || eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return;
        }
        eventLogClient.setPageSize(100);
        List events = eventLogClient.searchEventLog(new String[]{"snapshot.add", "snapshot.remove"});
        for (ItemCollection eventLogEntry : events) {
            topic = eventLogEntry.getItemValueString("topic");
            id = eventLogEntry.getItemValueString("id");
            ref = eventLogEntry.getItemValueString("ref");
            try {
                eventLogClient.lockEventLogEntry(id);
                if (topic.startsWith("snapshot.add")) {
                    logger.finest("......pull snapshot " + ref + "....");
                    this.pullSnapshot(eventLogEntry, documentClient, eventLogClient);
                }
                if (topic.startsWith("snapshot.remove")) {
                    logger.info("Remove Snapshot not yet implemented");
                }
                eventLogClient.deleteEventLogEntry(id);
            }
            catch (EJBException | ArchiveException | InvalidAccessException e) {
                logger.severe("SnapshotEvent " + id + " pull failed: " + e.getMessage());
                logger.warning("SnapshotEvent " + id + " will be removed!");
                eventLogClient.deleteEventLogEntry(id);
            }
        }
    }

    @Asynchronous
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void releaseDeadLocks(EventLogClient eventLogClient) throws RestAPIException {
        if (eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return;
        }
        eventLogClient.releaseDeadLocks(this.deadLockInterval, new String[]{"snapshot.add", "snapshot.remove"});
    }

    public void pullSnapshot(ItemCollection eventLogEntry, DocumentClient documentClient, EventLogClient eventLogClient) throws ArchiveException {
        if (eventLogEntry == null || documentClient == null || eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        String ref = eventLogEntry.getItemValueString("ref");
        String id = eventLogEntry.getItemValueString("id");
        logger.finest("...push " + ref + "...");
        long l = System.currentTimeMillis();
        try {
            ItemCollection snapshot = documentClient.getDocument(ref);
            if (snapshot != null) {
                logger.finest("...write snapshot...");
                this.dataService.saveSnapshot(snapshot);
                if (debug) {
                    logger.fine("...pulled " + ref + " in " + (System.currentTimeMillis() - l) + "ms");
                }
            }
        }
        catch (RestAPIException e) {
            logger.severe("Snapshot " + ref + " pull failed: " + e.getMessage());
            logger.warning("EventLogEntry " + id + " will be removed!");
            try {
                eventLogClient.deleteEventLogEntry(id);
            }
            catch (RestAPIException e1) {
                throw new ArchiveException("REMOTE_EXCEPTION", "Unable to delte eventLogEntry: " + id, (Exception)((Object)e1));
            }
        }
    }
}

