/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.restore;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.inject.Inject;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.RemoteAPIService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.resync.ResyncService;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class RestoreService {
    public static final String TIMER_ID_RESTORESERVICE = "IMIXS_ARCHIVE_RESTORE_TIMER";
    public static final long TIMER_INTERVAL_DURATION = 60000L;
    public static final String ITEM_RESTORE_FROM = "restore.from";
    public static final String ITEM_RESTORE_TO = "restore.to";
    public static final String ITEM_RESTORE_SYNCPOINT = "restore.point";
    public static final String ITEM_RESTORE_SYNCCOUNT = "restore.count";
    public static final String ITEM_RESTORE_SYNCERRORS = "restore.errors";
    public static final String ITEM_RESTORE_SYNCSIZE = "restore.size";
    public static final String ITEM_RESTORE_OPTIONS = "restore.options";
    public static final String MESSAGE_TOPIC = "restore";
    private static Logger logger = Logger.getLogger(RestoreService.class.getName());
    @Inject
    DataService dataService;
    @Inject
    ClusterService clusterService;
    @Inject
    MessageService messageService;
    @Inject
    RemoteAPIService remoteAPIService;
    @Resource
    TimerService timerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long restoreFrom, long restoreTo, List<Map> options) throws ArchiveException {
        Timer timer = null;
        timer = this.findTimer();
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Failed to stop existing timer - " + e.getMessage());
                throw new ArchiveException(ResyncService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        logger.info("...starting scheduler restore-service...");
        Object session = null;
        Object cluster = null;
        try {
            logger.info("...... restore from=" + this.dataService.getSyncPointISO(restoreFrom));
            logger.info("...... restore   to=" + this.dataService.getSyncPointISO(restoreTo));
            ItemCollection metaData = this.dataService.loadMetadata();
            metaData.setItemValue(ITEM_RESTORE_FROM, (Object)restoreFrom);
            metaData.setItemValue(ITEM_RESTORE_TO, (Object)restoreTo);
            metaData.setItemValue(ITEM_RESTORE_SYNCPOINT, (Object)restoreFrom);
            metaData.setItemValue(ITEM_RESTORE_SYNCCOUNT, (Object)0);
            metaData.setItemValue(ITEM_RESTORE_SYNCSIZE, (Object)0);
            metaData.setItemValue(ITEM_RESTORE_OPTIONS, options);
            this.dataService.saveMetadata(metaData);
            timer = this.timerService.createTimer(new Date(), 60000L, (Serializable)((Object)TIMER_ID_RESTORESERVICE));
            if (timer != null) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Timer started.");
            }
        }
        catch (Exception e) {
            logger.warning("...Failed to update metadata: " + e.getMessage());
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout
    void onTimeout(Timer timer) throws Exception {
        Object session = null;
        Object cluster = null;
        ItemCollection metadata = null;
        int restoreCount = 0;
        int restoreErrors = 0;
        long restoreSize = 0L;
        long startTime = System.currentTimeMillis();
        try {
            metadata = this.dataService.loadMetadata();
            long syncpoint = metadata.getItemValueLong(ITEM_RESTORE_SYNCPOINT);
            List options = this.getOptions(metadata);
            LocalDateTime localDateSyncPoint = new Date(syncpoint).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            long restoreFrom = metadata.getItemValueLong(ITEM_RESTORE_FROM);
            long restoreTo = metadata.getItemValueLong(ITEM_RESTORE_TO);
            LocalDateTime localDateRestoreTo = new Date(restoreTo).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            logger.info("......restore:    from " + this.dataService.getSyncPointISO(restoreFrom) + " to " + this.dataService.getSyncPointISO(restoreTo));
            logger.info("......restore.point:  " + this.dataService.getSyncPointISO(syncpoint));
            while (localDateRestoreTo.isAfter(localDateSyncPoint)) {
                List snapshotIDs = this.dataService.loadSnapshotsByDate(localDateSyncPoint.toLocalDate());
                if (!snapshotIDs.isEmpty()) {
                    logger.info("......restore snapshot date " + localDateSyncPoint);
                    for (String snapshotID : snapshotIDs) {
                        String latestSnapshot = this.findLatestSnapshotID(snapshotID, restoreFrom, restoreTo);
                        if (latestSnapshot != null) {
                            String remoteSnapshotID = this.remoteAPIService.readSnapshotIDByUniqueID(this.dataService.getUniqueID(latestSnapshot));
                            if (latestSnapshot.equals(remoteSnapshotID)) {
                                logger.finest("......no need to restore - snapshot:" + latestSnapshot + " is up to date!");
                                continue;
                            }
                            if (!this.matchFilterOptions(latestSnapshot, options)) continue;
                            long _tmpSize = -1L;
                            try {
                                logger.finest("......restoring: " + latestSnapshot);
                                ItemCollection snapshot = this.dataService.loadSnapshot(latestSnapshot);
                                _tmpSize = this.dataService.calculateSize(XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
                                logger.finest("......size=: " + _tmpSize);
                                this.remoteAPIService.restoreSnapshot(snapshot);
                                restoreSize += _tmpSize;
                                ++restoreCount;
                                snapshot = null;
                            }
                            catch (Exception e) {
                                logger.severe("...Failed to restore '" + latestSnapshot + "' (" + this.messageService.userFriendlyBytes(_tmpSize) + ") - " + e.getMessage());
                                ++restoreErrors;
                            }
                            continue;
                        }
                        logger.warning(".... unexpected data situation:  we found no latest snapthost matching our restore time range!");
                    }
                }
                localDateSyncPoint = localDateSyncPoint.plusDays(1L);
                Date date = Date.from(localDateSyncPoint.atZone(ZoneId.systemDefault()).toInstant());
                metadata.setItemValue(ITEM_RESTORE_SYNCPOINT, (Object)date.getTime());
                metadata.setItemValue(ITEM_RESTORE_SYNCCOUNT, (Object)restoreCount);
                metadata.setItemValue(ITEM_RESTORE_SYNCSIZE, (Object)restoreSize);
                metadata.setItemValue(ITEM_RESTORE_SYNCERRORS, (Object)restoreErrors);
                this.dataService.saveMetadata(metadata);
            }
            logger.info("...restore finished in: " + (System.currentTimeMillis() - startTime) + "ms");
            logger.info(".......final syncpoint: " + localDateSyncPoint);
            logger.info(".......total count:" + restoreCount);
            logger.info(".......total size:" + this.messageService.userFriendlyBytes(restoreSize));
            logger.info(".......total errors:" + restoreErrors);
            timer.cancel();
        }
        catch (Exception e) {
            logger.severe("Failed to restore data: " + e.getMessage());
            timer.cancel();
        }
        finally {
            if (session != null) {
                session.close();
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    String findLatestSnapshotID(String snapshotID, long restoreFrom, long restoreTo) {
        String latestSnapshot = null;
        String uniqueID = this.dataService.getUniqueID(snapshotID);
        String sql = "select * from snapshots_by_uniqueid where uniqueid='?'";
        sql = sql.replace("'?'", "'" + uniqueID + "'");
        sql = sql + " AND snapshot>='" + uniqueID + "-" + restoreFrom + "'";
        sql = sql + " AND snapshot<='" + uniqueID + "-" + restoreTo + "'";
        sql = sql + " ORDER BY snapshot DESC";
        sql = sql + " LIMIT 1";
        logger.finest("......query latest snapshot by date: " + sql);
        ResultSet rs = this.clusterService.getSession().execute(sql);
        Iterator resultIter = rs.iterator();
        if (resultIter.hasNext()) {
            Row row = (Row)resultIter.next();
            latestSnapshot = row.getString(1);
        }
        return latestSnapshot;
    }

    boolean matchFilterOptions(String snapshotID, List<ItemCollection> options) throws ArchiveException {
        ItemCollection _tmp_snapshot_data = null;
        if (options == null || options.size() == 0) {
            return true;
        }
        _tmp_snapshot_data = this.dataService.loadSnapshot(snapshotID, false);
        for (ItemCollection option : options) {
            String itemName = option.getItemValueString("name");
            Pattern regexPattern = Pattern.compile(option.getItemValueString("filter").trim());
            List valueList = _tmp_snapshot_data.getItemValueList(itemName, String.class);
            for (String value : valueList) {
                if (regexPattern.matcher(value).find()) continue;
                logger.fine(" snapshot value '" + value + "' did not match filter option '" + regexPattern + "'");
                _tmp_snapshot_data = null;
                return false;
            }
        }
        _tmp_snapshot_data = null;
        return true;
    }

    public Timer findTimer() {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!TIMER_ID_RESTORESERVICE.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    public List<ItemCollection> getOptions(ItemCollection metaData) {
        ArrayList<ItemCollection> result = new ArrayList<ItemCollection>();
        List mapOrderItems = metaData.getItemValue(ITEM_RESTORE_OPTIONS);
        for (Object mapOderItem : mapOrderItems) {
            if (!(mapOderItem instanceof Map)) continue;
            ItemCollection itemCol = new ItemCollection((Map)mapOderItem);
            result.add(itemCol);
        }
        return result;
    }

    public void setOptions(List<ItemCollection> options, ItemCollection metaData) {
        ArrayList<Map> mapOrderItems = new ArrayList<Map>();
        if (options != null) {
            logger.fine("Convert option items into Map...");
            for (ItemCollection orderItem : options) {
                mapOrderItems.add(orderItem.getAllItems());
            }
            metaData.replaceItemValue(ITEM_RESTORE_OPTIONS, mapOrderItems);
        }
    }
}

