/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.exports.ExportService;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;

@Named
@RequestScoped
public class ExportDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ExportDataController.class.getName());
    String syncSizeUnit = null;
    ItemCollection metaData = null;
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Inject
    ExportService exportService;
    @Inject
    MessageService messageService;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_CONTACTPOINTS", defaultValue="")
    String contactPoint;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_KEYSPACE", defaultValue="")
    String keySpace;
    @Inject
    @ConfigProperty(name="EXPORT_SCHEDULER_DEFINITION", defaultValue="")
    String schedulerDefinition;

    @PostConstruct
    void init() {
        try {
            this.metaData = this.dataService.loadMetadata();
        }
        catch (ArchiveException e) {
            logger.severe("Failed to load meta data!");
            e.printStackTrace();
        }
    }

    public void startExport() {
        try {
            this.exportService.startScheduler();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public void stopExport() {
        try {
            this.exportService.stopScheduler();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public Date getExportPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("export.point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public long getExportCount() {
        return this.metaData.getItemValueLong("export.count");
    }

    public String getExportSize() {
        long l = this.metaData.getItemValueLong("export.size");
        String result = this.messageService.userFriendlyBytes(l);
        String[] parts = result.split(" ");
        this.syncSizeUnit = parts[1];
        return parts[0];
    }

    public String getExportSizeUnit() {
        return this.syncSizeUnit;
    }

    public String getScheduler() {
        return this.schedulerDefinition;
    }

    public Date getNextTimeout() {
        return this.exportService.getNextTimeout();
    }

    public List<String> getMessages() {
        List messageLog = this.messageService.getMessages("export");
        ArrayList<String> result = new ArrayList<String>();
        for (String message : messageLog) {
            result.add(message);
        }
        Collections.reverse(result);
        return result;
    }

    public void reset() {
        try {
            this.metaData = this.exportService.reset();
        }
        catch (ArchiveException e) {
            logger.severe("failed to reset export syncpoint: " + e.getMessage());
        }
    }
}

