/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class FTPConnector {
    public static final String FTP_ERROR = "FTP_ERROR";
    @Inject
    DataService dataService;
    private static Logger logger = Logger.getLogger(FTPConnector.class.getName());
    @Inject
    @ConfigProperty(name="EXPORT_FTP_HOST", defaultValue="")
    String ftpServer;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_PATH", defaultValue="")
    String ftpPath;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_PORT", defaultValue="21")
    int ftpPort;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_USER", defaultValue="")
    String ftpUser;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_PASSWORD", defaultValue="")
    String ftpPassword;

    public void put(ItemCollection snapshot) throws ArchiveException {
        if (this.ftpServer.isEmpty()) {
            throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: no ftp host name provided (EXPORT_FTP_HOST)!");
        }
        String snapshotID = snapshot.getUniqueID();
        String originUnqiueID = this.dataService.getUniqueID(snapshotID);
        byte[] rawData = this.dataService.getRawData(snapshot);
        String fileName = originUnqiueID + ".xml";
        Date created = snapshot.getItemValueDate("$created");
        String ftpWorkingPath = this.ftpPath;
        if (!ftpWorkingPath.startsWith("/")) {
            ftpWorkingPath = "/" + ftpWorkingPath;
        }
        if (!ftpWorkingPath.endsWith("/")) {
            ftpWorkingPath = ftpWorkingPath + "/";
        }
        InputStream writer = null;
        FTPSClient ftpClient = null;
        try {
            logger.finest("......put " + fileName + " to FTP server: " + this.ftpServer + "...");
            ftpClient = new FTPSClient("TLS", false);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.connect(this.ftpServer, this.ftpPort);
            if (!ftpClient.login(this.ftpUser, this.ftpPassword)) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: login failed!");
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setControlEncoding("UTF-8");
            if (!ftpClient.changeWorkingDirectory(ftpWorkingPath)) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: missing working directory '" + ftpWorkingPath + "' : " + ftpClient.getReplyString());
            }
            this.changeWorkingDirectory((FTPClient)ftpClient, new SimpleDateFormat("yyyy").format(created));
            this.changeWorkingDirectory((FTPClient)ftpClient, new SimpleDateFormat("MM").format(created));
            writer = new ByteArrayInputStream(rawData);
            if (!ftpClient.storeFile(fileName, writer)) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: unable to write '" + ftpWorkingPath + fileName + "' : " + ftpClient.getReplyString());
            }
            logger.finest("...." + ftpWorkingPath + fileName + " transfered successfull to " + this.ftpServer);
        }
        catch (IOException e) {
            throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (IOException e) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
            }
        }
    }

    public ItemCollection get(FTPClient ftpClient, String fileName) throws ArchiveException {
        if (ftpClient == null) {
            throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: no ftpClient provided!");
        }
        long l = System.currentTimeMillis();
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            ftpClient.retrieveFile(fileName, (OutputStream)bos);
            byte[] result = bos.toByteArray();
            ItemCollection snapshot = XMLDocumentAdapter.readItemCollection((byte[])result);
            logger.finest("......" + fileName + " transfered successfull from " + this.ftpServer + " in " + (System.currentTimeMillis() - l) + "ms");
            ItemCollection itemCollection = snapshot;
            return itemCollection;
        }
        catch (IOException | JAXBException e) {
            throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
            }
        }
    }

    private void changeWorkingDirectory(FTPClient ftpClient, String subDirectory) throws ArchiveException {
        try {
            if (!ftpClient.changeWorkingDirectory(subDirectory)) {
                if (!ftpClient.makeDirectory(subDirectory)) {
                    throw new ArchiveException(FTP_ERROR, "FTP Error: unable to create sub-directory '" + subDirectory + "' : " + ftpClient.getReplyString());
                }
                ftpClient.changeWorkingDirectory(subDirectory);
            }
        }
        catch (IOException e) {
            throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: " + e.getMessage(), (Exception)e);
        }
    }
}

