/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.imixs.archive.service.cassandra.ClusterService;

@Health
@ApplicationScoped
public class HealthCheckService
implements HealthCheck {
    private String archiveVersion = null;
    private static Logger logger = Logger.getLogger(HealthCheckService.class.getName());
    @Inject
    ClusterService clusterService;

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = null;
        builder = this.clusterService.getSession() != null ? HealthCheckResponse.named((String)"imixs-archive").withData("archive.version", this.getArchiveVersion()).up() : HealthCheckResponse.named((String)"imixs-archive").down();
        return builder.build();
    }

    private String getArchiveVersion() {
        if (this.archiveVersion == null) {
            try {
                InputStream resourceAsStream = this.getClass().getResourceAsStream("/META-INF/maven/org.imixs.workflow/imixs-archive-service/pom.properties");
                if (resourceAsStream != null) {
                    Properties prop = new Properties();
                    prop.load(resourceAsStream);
                    this.archiveVersion = prop.getProperty("version");
                }
            }
            catch (IOException e1) {
                logger.warning("failed to load pom.properties");
            }
        }
        if (this.archiveVersion == null || this.archiveVersion.isEmpty()) {
            this.archiveVersion = "unknown";
        }
        return this.archiveVersion;
    }
}

