/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.imports.ImportService;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;

@Named
@RequestScoped
public class ImportDataController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ImportDataController.class.getName());
    String syncSizeUnit = null;
    ItemCollection metaData = null;
    @Inject
    ClusterService clusterService;
    @Inject
    DataService dataService;
    @Inject
    ImportService importService;
    @Inject
    MessageService messageService;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_CONTACTPOINTS", defaultValue="")
    String contactPoint;
    @Inject
    @ConfigProperty(name="ARCHIVE_CLUSTER_KEYSPACE", defaultValue="")
    String keySpace;
    @Inject
    @ConfigProperty(name="EXPORT_SCHEDULER_DEFINITION", defaultValue="")
    String schedulerDefinition;

    @PostConstruct
    void init() {
        try {
            this.metaData = this.dataService.loadMetadata();
        }
        catch (ArchiveException e) {
            logger.severe("Failed to load meta data!");
            e.printStackTrace();
        }
    }

    public void start() {
        try {
            this.importService.start();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }

    public Date getImportPoint() {
        long lsyncPoint = this.metaData.getItemValueLong("import.point");
        Date syncPoint = new Date(lsyncPoint);
        return syncPoint;
    }

    public long getImportCount() {
        return this.metaData.getItemValueLong("import.count");
    }

    public String getImportSize() {
        long l = this.metaData.getItemValueLong("import.size");
        String result = this.messageService.userFriendlyBytes(l);
        String[] parts = result.split(" ");
        this.syncSizeUnit = parts[1];
        return parts[0];
    }

    public String getImportSizeUnit() {
        return this.syncSizeUnit;
    }

    public List<String> getMessages() {
        List messageLog = this.messageService.getMessages("import");
        ArrayList<String> result = new ArrayList<String>();
        for (String message : messageLog) {
            result.add(message);
        }
        Collections.reverse(result);
        return result;
    }

    public boolean isRunning() {
        return this.importService.isRunning();
    }

    public void cancel() {
        try {
            this.importService.cancel();
        }
        catch (ArchiveException e) {
            e.printStackTrace();
        }
    }
}

