/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.imports;

import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.inject.Inject;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.exports.ExportService;
import org.imixs.archive.service.imports.ImportStatusHandler;
import org.imixs.archive.service.util.FTPConnector;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class ImportService {
    public static final String TIMER_ID_IMPORTSERVICE = "IMIXS_ARCHIVE_IMPORT_TIMER";
    public static final String ITEM_IMPORTPOINT = "import.point";
    public static final String ITEM_IMPORTCOUNT = "import.count";
    public static final String ITEM_IMPORTSIZE = "import.size";
    public static final String ITEM_IMPORTERRORS = "import.errors";
    public static final String MESSAGE_TOPIC = "import";
    public static final String FTP_ERROR = "FTP_ERROR";
    @Inject
    @ConfigProperty(name="EXPORT_FTP_HOST")
    Optional<String> ftpServer;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_PATH")
    Optional<String> ftpPath;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_PORT", defaultValue="21")
    int ftpPort;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_USER")
    Optional<String> ftpUser;
    @Inject
    @ConfigProperty(name="EXPORT_FTP_PASSWORD")
    Optional<String> ftpPassword;
    @Inject
    DataService dataService;
    @Inject
    ClusterService clusterService;
    @Inject
    MessageService messageService;
    @Inject
    FTPConnector ftpConnector;
    @Inject
    ImportStatusHandler importStatusHandler;
    @Resource
    TimerService timerService;
    private static Logger logger = Logger.getLogger(ImportService.class.getName());

    public void start() throws ArchiveException {
        Timer timer = null;
        timer = this.findTimer();
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Failed to stop existing timer - " + e.getMessage());
                throw new ArchiveException(ExportService.class.getName(), "INVALID_WORKITEM", " failed to cancel existing timer!");
            }
        }
        logger.finest("...starting scheduler import-service ...");
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)((Object)TIMER_ID_IMPORTSERVICE));
        timer = this.timerService.createSingleActionTimer(0L, timerConfig);
        if (timer != null) {
            this.messageService.logMessage(MESSAGE_TOPIC, "Timer started.");
        }
    }

    @Timeout
    void onTimeout(Timer timer) throws ArchiveException {
        this.importStatusHandler.setStatus((byte)1);
        ItemCollection metaData = null;
        long lastImportPoint = 0L;
        long totalCount = 0L;
        long importSize = 0L;
        String lastUniqueID = null;
        if (!this.ftpServer.isPresent() || ((String)this.ftpServer.get()).isEmpty()) {
            this.messageService.logMessage(MESSAGE_TOPIC, "...Import failed - EXPORT_FTP_HOST not defined!");
            return;
        }
        try {
            FTPFile[] directoryListYears;
            metaData = this.dataService.loadMetadata();
            metaData.setItemValue(ITEM_IMPORTPOINT, (Object)lastImportPoint);
            metaData.setItemValue(ITEM_IMPORTCOUNT, (Object)0);
            metaData.setItemValue(ITEM_IMPORTSIZE, (Object)0);
            this.dataService.saveMetadata(metaData);
            this.messageService.logMessage(MESSAGE_TOPIC, "...starting import from " + this.ftpServer + "...");
            FTPSClient ftpClient = new FTPSClient("TLS", false);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.connect((String)this.ftpServer.get(), this.ftpPort);
            if (!ftpClient.login((String)this.ftpUser.get(), (String)this.ftpPassword.get())) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: login failed!");
            }
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setBufferSize(65536);
            String ftpRootPath = (String)this.ftpPath.get();
            if (!ftpRootPath.startsWith("/")) {
                ftpRootPath = "/" + ftpRootPath;
            }
            if (!ftpRootPath.endsWith("/")) {
                ftpRootPath = ftpRootPath + "/";
            }
            if (!ftpClient.changeWorkingDirectory(ftpRootPath)) {
                throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: missing workfing directory '" + ftpRootPath + "' : " + ftpClient.getReplyString());
            }
            String ftpWorkingPath = "";
            for (FTPFile ftpFileYear : directoryListYears = ftpClient.listDirectories()) {
                if (ftpFileYear.isDirectory()) {
                    FTPFile[] directoryListMonths;
                    ftpWorkingPath = ftpFileYear.getName();
                    if (!ftpClient.changeWorkingDirectory(ftpWorkingPath)) {
                        throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: missing working directory '" + ftpWorkingPath + "' : " + ftpClient.getReplyString());
                    }
                    for (FTPFile ftpFileMonth : directoryListMonths = ftpClient.listDirectories()) {
                        FTPFile[] importFiles;
                        if (!ftpFileMonth.isDirectory()) continue;
                        ftpWorkingPath = ftpFileMonth.getName();
                        if (!ftpClient.changeWorkingDirectory(ftpWorkingPath)) {
                            throw new ArchiveException(FTP_ERROR, "FTP file transfer failed: missing working directory '" + ftpWorkingPath + "' : " + ftpClient.getReplyString());
                        }
                        this.messageService.logMessage(MESSAGE_TOPIC, "......import: " + ftpFileYear.getName() + "/" + ftpWorkingPath + " ...");
                        int count = 0;
                        int verified = 0;
                        for (FTPFile importFile : importFiles = ftpClient.listFiles()) {
                            ItemCollection snapshot;
                            if (importFile.isFile() && (snapshot = this.ftpConnector.get((FTPClient)ftpClient, importFile.getName())) != null) {
                                ++verified;
                                if (!this.dataService.existSnapshot(snapshot.getUniqueID())) {
                                    this.dataService.saveSnapshot(snapshot);
                                    logger.info("...." + snapshot.getUniqueID() + " successfull imported");
                                    ++count;
                                    ++totalCount;
                                    long _tmpSize = this.dataService.calculateSize(XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
                                    logger.finest("......size=: " + _tmpSize);
                                    importSize += _tmpSize;
                                    lastImportPoint = this.dataService.getSnapshotTime(snapshot.getUniqueID());
                                }
                            }
                            if (this.importStatusHandler.getStatus() == 2) break;
                        }
                        this.messageService.logMessage(MESSAGE_TOPIC, "......" + ftpFileYear.getName() + "/" + ftpWorkingPath + ": " + verified + " snapshots verified, " + count + " snapshots imported...");
                        metaData.setItemValue(ITEM_IMPORTPOINT, (Object)lastImportPoint);
                        metaData.setItemValue(ITEM_IMPORTCOUNT, (Object)totalCount);
                        metaData.setItemValue(ITEM_IMPORTSIZE, (Object)importSize);
                        this.dataService.saveMetadata(metaData);
                        ftpClient.changeToParentDirectory();
                        if (this.importStatusHandler.getStatus() == 2) break;
                    }
                }
                if (this.importStatusHandler.getStatus() != 2) {
                    ftpClient.changeToParentDirectory();
                    continue;
                }
                break;
            }
        }
        catch (IOException | RuntimeException | ArchiveException e) {
            if (logger.isLoggable(Level.FINE)) {
                e.printStackTrace();
            }
            this.messageService.logMessage(MESSAGE_TOPIC, "Import failed " + ("0".equals(lastUniqueID) ? " (failed to save metadata)" : "(last uniqueid=" + lastUniqueID + ")") + " : " + e.getMessage());
        }
        this.messageService.logMessage(MESSAGE_TOPIC, "... import completed!");
        this.stop(this.findTimer());
    }

    public void cancel() throws ArchiveException {
        this.importStatusHandler.setStatus((byte)2);
        this.messageService.logMessage(MESSAGE_TOPIC, "... import canceled!");
        this.stop(this.findTimer());
    }

    private void stop(Timer timer) throws ArchiveException {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Exception e) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Failed to stop timer - " + e.getMessage());
            }
            this.messageService.logMessage(MESSAGE_TOPIC, "Timer stopped. ");
            this.importStatusHandler.setStatus((byte)0);
        }
    }

    public boolean isRunning() {
        return this.findTimer() != null;
    }

    private Timer findTimer() {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!TIMER_ID_IMPORTSERVICE.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }
}

