/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.io.Serializable;
import java.util.Optional;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.LocalBean;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.client.ClientRequestFilter;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.SyncService;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.RestAPIException;

@Startup
@Singleton
@LocalBean
@DeclareRoles(value={"org.imixs.ACCESSLEVEL.MANAGERACCESS"})
@RunAs(value="org.imixs.ACCESSLEVEL.MANAGERACCESS")
public class SyncScheduler {
    @Inject
    @ConfigProperty(name="workflow.sync.interval", defaultValue="1000")
    long interval;
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> workflowServiceAuthMethod;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> workflowServiceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> workflowServicePassword;
    @Inject
    SyncService archiveSyncService;
    @Resource
    TimerService timerService;
    private static Logger logger = Logger.getLogger(SyncScheduler.class.getName());

    @PostConstruct
    public void init() {
        if (this.workflowServiceEndpoint.isPresent()) {
            logger.info("Starting Archive SyncScheduler - interval=" + this.interval + "ms ....");
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)""));
            timerConfig.setPersistent(false);
            this.timerService.createIntervalTimer(this.interval, this.interval, timerConfig);
        }
    }

    @Timeout
    public void run(Timer timer) {
        DocumentClient documentClient = null;
        EventLogClient eventLogClient = null;
        BasicAuthenticator authenticator = null;
        try {
            if ("Form".equalsIgnoreCase((String)this.workflowServiceAuthMethod.get())) {
                String jSessionID = (String)((Object)timer.getInfo());
                if (jSessionID == null || jSessionID.isEmpty()) {
                    FormAuthenticator formAuth = new FormAuthenticator((String)this.workflowServiceEndpoint.get(), (String)this.workflowServiceUser.get(), (String)this.workflowServicePassword.get());
                    String jsessionID = formAuth.getJsessionID();
                    if (jsessionID != null && !jsessionID.isEmpty()) {
                        timer.cancel();
                        TimerConfig timerConfig = new TimerConfig();
                        timerConfig.setInfo((Serializable)((Object)jsessionID));
                        timerConfig.setPersistent(false);
                        this.timerService.createIntervalTimer(this.interval, this.interval, timerConfig);
                        logger.info("successful connected: " + this.workflowServiceEndpoint);
                        return;
                    }
                } else {
                    FormAuthenticator formAuth = new FormAuthenticator((String)this.workflowServiceEndpoint.get(), jSessionID);
                    authenticator = formAuth;
                }
            } else {
                BasicAuthenticator basicAuth;
                authenticator = basicAuth = new BasicAuthenticator((String)this.workflowServiceUser.get(), (String)this.workflowServicePassword.get());
            }
            if (authenticator != null) {
                documentClient = new DocumentClient((String)this.workflowServiceEndpoint.get());
                documentClient.registerClientRequestFilter((ClientRequestFilter)authenticator);
                eventLogClient = new EventLogClient((String)this.workflowServiceEndpoint.get());
                eventLogClient.registerClientRequestFilter((ClientRequestFilter)authenticator);
                this.archiveSyncService.releaseDeadLocks(eventLogClient);
                this.archiveSyncService.processEventLog(eventLogClient, documentClient);
            } else {
                logger.warning("unable to connect: " + this.workflowServiceEndpoint);
            }
        }
        catch (NotFoundException | RestAPIException e) {
            logger.warning("unable to process event log: " + e.getMessage());
            timer.cancel();
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)""));
            timerConfig.setPersistent(false);
            this.timerService.createIntervalTimer(this.interval, this.interval, timerConfig);
        }
    }
}

