/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.exports.ExportService;
import org.imixs.archive.service.resync.ResyncService;
import org.imixs.archive.service.util.MessageService;

@ApplicationPath(value="api")
public class ImixsArchiveApp
extends Application {
    public static final String EVENTLOG_TOPIC_ADD = "snapshot.add";
    public static final String EVENTLOG_TOPIC_REMOVE = "snapshot.remove";
    public static final String WORKFLOW_SERVICE_ENDPOINT = "workflow.service.endpoint";
    public static final String WORKFLOW_SERVICE_USER = "workflow.service.user";
    public static final String WORKFLOW_SERVICE_PASSWORD = "workflow.service.password";
    public static final String WORKFLOW_SERVICE_AUTHMETHOD = "workflow.service.authmethod";
    public static final String WORKFLOW_SYNC_INTERVAL = "workflow.sync.interval";
    public static final String WORKFLOW_SYNC_INITIALDELAY = "workflow.sync.initialdelay";
    public static final String WORKFLOW_SYNC_DEADLOCK = "workflow.sync.deadlock";
    @Inject
    ResyncService syncService;
    @Inject
    MessageService messageService;
    @Inject
    ExportService exportService;

    @PostConstruct
    public void initialize() {
        if (this.syncService != null) {
            try {
                this.syncService.start();
                this.exportService.startScheduler();
            }
            catch (ArchiveException e) {
                this.messageService.logMessage("sync", "Failed to start scheduler - " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

