/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.imixs.archive.service.cassandra.ArchiveEvent;
import org.imixs.workflow.exceptions.AccessDeniedException;

@ApplicationScoped
public class MetricService {
    public static final String METRIC_DOCUMENTS = "documents";
    @Inject
    @ConfigProperty(name="metrics.enabled", defaultValue="false")
    private boolean metricsEnabled;
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry metricRegistry;
    boolean mpMetricNoSupport = false;
    private static Logger logger = Logger.getLogger(MetricService.class.getName());

    public void onArchiveEvent(@Observes ArchiveEvent archiveEvent) throws AccessDeniedException {
        if (!this.metricsEnabled) {
            return;
        }
        if (archiveEvent == null) {
            return;
        }
        if (this.mpMetricNoSupport) {
            return;
        }
        try {
            Counter counter = this.buildArchiveMetric(archiveEvent);
            counter.inc();
        }
        catch (IncompatibleClassChangeError | ObserverException oe) {
            this.mpMetricNoSupport = true;
            logger.warning("...Microprofile Metrics v2.2 not supported!");
        }
    }

    private Counter buildArchiveMetric(ArchiveEvent event) {
        Metadata metadata = Metadata.builder().withName(METRIC_DOCUMENTS).withDescription("Imixs-Workflow count documents").withType(MetricType.COUNTER).build();
        String method = null;
        if (1 == event.getEventType()) {
            method = "archive";
        }
        if (2 == event.getEventType()) {
            method = "restore";
        }
        if (3 == event.getEventType()) {
            method = "delete";
        }
        Tag[] tags = new Tag[]{new Tag("method", method)};
        Counter counter = this.metricRegistry.counter(metadata, tags);
        return counter;
    }
}

