/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.util.Optional;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestFilter;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.melman.BasicAuthenticator;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.FormAuthenticator;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class RemoteAPIService {
    public static final String SNAPSHOT_RESOURCE = "snapshot/";
    public static final String DOCUMENTS_RESOURCE = "documents/";
    public static final String SNAPSHOT_SYNCPOINT_RESOURCE = "snapshot/syncpoint/";
    private static Logger logger = Logger.getLogger(RemoteAPIService.class.getName());
    @Inject
    @ConfigProperty(name="WORKFLOW_SERVICE_ENDPOINT")
    Optional<String> workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="WORKFLOW_SERVICE_USER")
    Optional<String> workflowServiceUser;
    @Inject
    @ConfigProperty(name="WORKFLOW_SERVICE_PASSWORD")
    Optional<String> workflowServicePassword;
    @Inject
    @ConfigProperty(name="WORKFLOW_SERVICE_AUTHMETHOD")
    Optional<String> workflowServiceAuthMethod;

    public XMLDataCollection readSyncData(long syncPoint) throws ArchiveException {
        XMLDataCollection result = null;
        DocumentClient documentClient = this.initWorkflowClient();
        String url = SNAPSHOT_SYNCPOINT_RESOURCE + syncPoint;
        logger.finest("...... read data: " + url + "....");
        try {
            result = documentClient.getCustomResourceXML(url);
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed readSyncData at : " + url + "  Error Message: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
        if (result != null && result.getDocument().length > 0) {
            return result;
        }
        return null;
    }

    public String readSnapshotIDByUniqueID(String uniqueid) throws ArchiveException {
        String result = null;
        DocumentClient documentClient = this.initWorkflowClient();
        String url = DOCUMENTS_RESOURCE + uniqueid + "?items=$snapshotid";
        logger.finest("...... read snapshotid: " + url + "....");
        try {
            XMLDataCollection xmlDocument = documentClient.getCustomResourceXML(url);
            if (xmlDocument != null && xmlDocument.getDocument().length > 0) {
                ItemCollection document = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument.getDocument()[0]);
                result = document.getItemValueString("$snapshotid");
            }
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to readSyncData : " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
        return result;
    }

    public void restoreSnapshot(ItemCollection snapshot) throws ArchiveException {
        DocumentClient documentClient = this.initWorkflowClient();
        String url = SNAPSHOT_RESOURCE;
        logger.finest("...... post data: " + url + "....");
        try {
            documentClient.postXMLDocument(url, XMLDocumentAdapter.getDocument((ItemCollection)snapshot));
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to restoreSnapshot: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
    }

    public void deleteSnapshot(String id) throws ArchiveException {
        DocumentClient documentClient = this.initWorkflowClient();
        String url = SNAPSHOT_RESOURCE;
        logger.finest("...... delete data: " + url + "....");
        try {
            documentClient.deleteDocument(id);
        }
        catch (RestAPIException e) {
            String errorMessage = "...failed to deleteSnapshot: " + e.getMessage();
            throw new ArchiveException("SYNC_ERROR", errorMessage, (Exception)((Object)e));
        }
    }

    DocumentClient initWorkflowClient() {
        logger.finest("...... WORKFLOW_SERVICE_ENDPOINT = " + this.workflowServiceEndpoint);
        DocumentClient documentClient = new DocumentClient((String)this.workflowServiceEndpoint.get());
        if ("Form".equalsIgnoreCase((String)this.workflowServiceAuthMethod.get())) {
            FormAuthenticator formAuth = new FormAuthenticator((String)this.workflowServiceEndpoint.get(), (String)this.workflowServiceUser.get(), (String)this.workflowServicePassword.get());
            documentClient.registerClientRequestFilter((ClientRequestFilter)formAuth);
        } else {
            BasicAuthenticator basicAuth = new BasicAuthenticator((String)this.workflowServiceUser.get(), (String)this.workflowServicePassword.get());
            documentClient.registerClientRequestFilter((ClientRequestFilter)basicAuth);
        }
        return documentClient;
    }
}

