/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service;

import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBException;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.melman.DocumentClient;
import org.imixs.melman.EventLogClient;
import org.imixs.melman.RestAPIException;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.exceptions.InvalidAccessException;

@Stateless
@LocalBean
public class SyncService {
    @Inject
    @ConfigProperty(name="workflow.service.endpoint")
    Optional<String> workflowServiceEndpoint;
    @Inject
    @ConfigProperty(name="workflow.service.user")
    Optional<String> workflowServiceUser;
    @Inject
    @ConfigProperty(name="workflow.service.password")
    Optional<String> workflowServicePassword;
    @Inject
    @ConfigProperty(name="workflow.service.authmethod")
    Optional<String> workflowServiceAuthMethod;
    @Inject
    @ConfigProperty(name="workflow.sync.deadlock", defaultValue="60000")
    long deadLockInterval;
    @Inject
    @ConfigProperty(name="backup.service.endpoint")
    Optional<String> backupServiceEndpoint;
    @Inject
    DataService dataService;
    private static Logger logger = Logger.getLogger(SyncService.class.getName());

    public void processEventLog(EventLogClient eventLogClient, DocumentClient documentClient) throws RestAPIException {
        String topic = null;
        String id = null;
        String ref = null;
        ItemCollection snapshot = null;
        if (documentClient == null || eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return;
        }
        eventLogClient.setPageSize(100);
        List events = eventLogClient.searchEventLog(new String[]{"snapshot.add", "snapshot.remove"});
        for (ItemCollection eventLogEntry : events) {
            topic = eventLogEntry.getItemValueString("topic");
            id = eventLogEntry.getItemValueString("id");
            ref = eventLogEntry.getItemValueString("ref");
            try {
                eventLogClient.lockEventLogEntry(id);
                if (topic.startsWith("snapshot.add")) {
                    logger.finest("......pull snapshot " + ref + "....");
                    snapshot = this.pullSnapshot(eventLogEntry, documentClient, eventLogClient);
                }
                if (topic.startsWith("snapshot.remove")) {
                    logger.info("Remove Snapshot not yet implemented");
                }
                eventLogClient.deleteEventLogEntry(id);
                if (!this.backupServiceEndpoint.isPresent() || ((String)this.backupServiceEndpoint.get()).isEmpty() || snapshot == null || snapshot.hasItem("$backuprestore")) continue;
                logger.finest("......create event log entry snapshot.backup");
                eventLogClient.createEventLogEntry("snapshot.backup", ref, null);
            }
            catch (EJBException | ArchiveException | InvalidAccessException e) {
                logger.severe("SnapshotEvent " + id + " pull failed: " + e.getMessage());
                logger.warning("SnapshotEvent " + id + " will be removed!");
                eventLogClient.deleteEventLogEntry(id);
            }
        }
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void releaseDeadLocks(EventLogClient eventLogClient) throws RestAPIException {
        if (eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return;
        }
        eventLogClient.releaseDeadLocks(this.deadLockInterval, new String[]{"snapshot.add", "snapshot.remove"});
    }

    public ItemCollection pullSnapshot(ItemCollection eventLogEntry, DocumentClient documentClient, EventLogClient eventLogClient) throws ArchiveException {
        if (eventLogEntry == null || documentClient == null || eventLogClient == null) {
            logger.fine("...no eventLogClient available!");
            return null;
        }
        boolean debug = logger.isLoggable(Level.FINE);
        String ref = eventLogEntry.getItemValueString("ref");
        String id = eventLogEntry.getItemValueString("id");
        logger.finest("...push " + ref + "...");
        long l = System.currentTimeMillis();
        try {
            ItemCollection snapshot = documentClient.getDocument(ref);
            if (snapshot != null) {
                logger.finest("...write snapshot...");
                this.dataService.saveSnapshot(snapshot);
                if (debug) {
                    logger.fine("...pulled " + ref + " in " + (System.currentTimeMillis() - l) + "ms");
                }
                return snapshot;
            }
        }
        catch (RestAPIException e) {
            logger.severe("Snapshot " + ref + " pull failed: " + e.getMessage());
            logger.warning("EventLogEntry " + id + " will be removed!");
            try {
                eventLogClient.deleteEventLogEntry(id);
            }
            catch (RestAPIException e1) {
                throw new ArchiveException("REMOTE_EXCEPTION", "Unable to delte eventLogEntry: " + id, (Exception)((Object)e1));
            }
        }
        return null;
    }
}

