/*
 * Decompiled with CFR 0.152.
 */
package org.imixs.archive.service.resync;

import jakarta.annotation.Resource;
import jakarta.ejb.Stateless;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import jakarta.ejb.TimerService;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import org.imixs.archive.service.ArchiveException;
import org.imixs.archive.service.RemoteAPIService;
import org.imixs.archive.service.cassandra.ClusterService;
import org.imixs.archive.service.cassandra.DataService;
import org.imixs.archive.service.resync.ResyncStatusHandler;
import org.imixs.archive.service.util.MessageService;
import org.imixs.workflow.ItemCollection;
import org.imixs.workflow.xml.XMLDataCollection;
import org.imixs.workflow.xml.XMLDocument;
import org.imixs.workflow.xml.XMLDocumentAdapter;

@Stateless
public class ResyncService {
    public static final String TIMER_ID_SYNCSERVICE = "IMIXS_ARCHIVE_RESYNC_TIMER";
    public static final String ITEM_SYNCPOINT = "sync.point";
    public static final String ITEM_SYNCCOUNT = "sync.count";
    public static final String ITEM_SYNCSIZE = "sync.size";
    public static final String DEFAULT_SCHEDULER_DEFINITION = "hour=*";
    public static final String MESSAGE_TOPIC = "sync";
    private static final int MAX_COUNT = 100;
    @Resource
    TimerService timerService;
    @Inject
    DataService dataService;
    @Inject
    ClusterService clusterService;
    @Inject
    MessageService messageService;
    @Inject
    RemoteAPIService remoteAPIService;
    @Inject
    ResyncStatusHandler syncStatusHandler;
    private static Logger logger = Logger.getLogger(ResyncService.class.getName());

    public void start() throws ArchiveException {
        Timer timer = null;
        timer = this.findTimer();
        if (timer != null) {
            try {
                timer.cancel();
                timer = null;
            }
            catch (Exception e) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Failed to stop existing timer - " + e.getMessage());
                throw new ArchiveException(ResyncService.class.getName(), "INVALID_WORKITEM", " failed to cancle existing timer!");
            }
        }
        if (this.clusterService.getSession() != null) {
            logger.finest("...starting scheduler sync-service ...");
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)((Object)TIMER_ID_SYNCSERVICE));
            timer = this.timerService.createSingleActionTimer(0L, timerConfig);
            if (timer != null) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Timer started.");
            }
        } else {
            logger.warning("...Failed to initalize imixs-archive keyspace!");
        }
    }

    public void cancel() throws ArchiveException {
        this.syncStatusHandler.setStatus((byte)2);
        this.messageService.logMessage(MESSAGE_TOPIC, "... sync canceled!");
        this.stop(this.findTimer());
    }

    public boolean isRunning() {
        return this.findTimer() != null;
    }

    private void stop(Timer timer) throws ArchiveException {
        if (timer != null) {
            try {
                timer.cancel();
            }
            catch (Exception e) {
                this.messageService.logMessage(MESSAGE_TOPIC, "Failed to stop timer - " + e.getMessage());
            }
            this.messageService.logMessage(MESSAGE_TOPIC, "Timer stopped. ");
        }
    }

    private Timer findTimer() {
        for (Object obj : this.timerService.getTimers()) {
            Timer timer = (Timer)obj;
            if (!TIMER_ID_SYNCSERVICE.equals(timer.getInfo())) continue;
            return timer;
        }
        return null;
    }

    @Timeout
    void onTimeout(Timer timer) throws Exception {
        long syncPoint = 0L;
        int syncupdate = 0;
        int syncread = 0;
        long totalCount = 0L;
        long totalSize = 0L;
        ItemCollection metaData = null;
        String lastUniqueID = null;
        long lProfiler = System.currentTimeMillis();
        try {
            block10: {
                XMLDataCollection xmlDataCollection;
                metaData = this.dataService.loadMetadata();
                syncPoint = metaData.getItemValueLong(ITEM_SYNCPOINT);
                totalCount = metaData.getItemValueLong(ITEM_SYNCCOUNT);
                totalSize = metaData.getItemValueLong(ITEM_SYNCSIZE);
                logger.info("...start syncronizing at syncpoint " + new Date(syncPoint) + "...");
                Date now = new Date();
                if (syncPoint > now.getTime()) {
                    logger.warning("...current syncpoint (" + syncPoint + ") is in the future! Adjust Syncpoint to now (" + now.getTime() + ")....");
                    syncPoint = now.getTime();
                }
                while ((xmlDataCollection = this.remoteAPIService.readSyncData(syncPoint)) != null) {
                    List<XMLDocument> snapshotList = Arrays.asList(xmlDataCollection.getDocument());
                    for (XMLDocument xmlDocument : snapshotList) {
                        ItemCollection snapshot = XMLDocumentAdapter.putDocument((XMLDocument)xmlDocument);
                        Date syncpointdate = snapshot.getItemValueDate("$modified");
                        syncPoint = syncpointdate.getTime();
                        logger.fine("......data found - new syncpoint=" + syncPoint);
                        if (!this.dataService.existSnapshot(snapshot.getUniqueID())) {
                            try {
                                lastUniqueID = snapshot.getUniqueID();
                                this.dataService.saveSnapshot(snapshot);
                                ++syncupdate;
                                ++totalCount;
                                totalSize += this.dataService.calculateSize(xmlDocument);
                            }
                            catch (RuntimeException e) {
                                logger.warning("Failed to resync snapshot id '" + snapshot.getUniqueID() + "' - error: " + e.getMessage());
                            }
                        } else {
                            logger.fine("...snapshot '" + snapshot.getUniqueID() + "' already exits....");
                        }
                        ++syncread;
                        metaData.setItemValue(ITEM_SYNCPOINT, (Object)syncPoint);
                        metaData.setItemValue(ITEM_SYNCCOUNT, (Object)totalCount);
                        metaData.setItemValue(ITEM_SYNCSIZE, (Object)totalSize);
                        lastUniqueID = "0";
                        this.dataService.saveMetadata(metaData);
                        if (this.syncStatusHandler.getStatus() != 2) continue;
                        break;
                    }
                    if (syncread > 100) {
                        this.messageService.logMessage(MESSAGE_TOPIC, "... " + syncread + " snapshots verified (" + syncupdate + " updates) in: " + (System.currentTimeMillis() - lProfiler) + " ms, next syncpoint " + new Date(syncPoint));
                        syncread = 0;
                    }
                    if (this.syncStatusHandler.getStatus() != 2) continue;
                    break block10;
                }
                logger.finest("......no more data found for syncpoint: " + syncPoint);
            }
            this.messageService.logMessage(MESSAGE_TOPIC, "...no more data found at syncpoint " + new Date(syncPoint) + " -> finishing synchroization.");
            this.stop(timer);
        }
        catch (RuntimeException | ArchiveException e) {
            e.printStackTrace();
            this.messageService.logMessage(MESSAGE_TOPIC, "sync failed " + (String)("0".equals(lastUniqueID) ? " (failed to save metadata)" : "(last uniqueid=" + lastUniqueID + ")") + " : " + e.getMessage());
            this.stop(timer);
        }
    }
}

